/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

final class OptionValidator {
    OptionValidator() {
    }

    static void validateOption(String opt) throws IllegalArgumentException {
        if (opt == null) {
            return;
        }
        if (opt.length() == 1) {
            char ch2 = opt.charAt(0);
            if (!OptionValidator.isValidOpt(ch2)) {
                throw new IllegalArgumentException("Illegal option name '" + ch2 + "'");
            }
        } else {
            for (char ch3 : opt.toCharArray()) {
                if (OptionValidator.isValidChar(ch3)) continue;
                throw new IllegalArgumentException("The option '" + opt + "' contains an illegal character : '" + ch3 + "'");
            }
        }
    }

    private static boolean isValidOpt(char c10) {
        return OptionValidator.isValidChar(c10) || c10 == '?' || c10 == '@';
    }

    private static boolean isValidChar(char c10) {
        return Character.isJavaIdentifierPart(c10);
    }
}

