/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Date;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class PatternOptionBuilder {
    public static final Class<String> STRING_VALUE = String.class;
    public static final Class<Object> OBJECT_VALUE = Object.class;
    public static final Class<Number> NUMBER_VALUE = Number.class;
    public static final Class<Date> DATE_VALUE = Date.class;
    public static final Class<?> CLASS_VALUE = Class.class;
    public static final Class<FileInputStream> EXISTING_FILE_VALUE = FileInputStream.class;
    public static final Class<File> FILE_VALUE = File.class;
    public static final Class<File[]> FILES_VALUE = File[].class;
    public static final Class<URL> URL_VALUE = URL.class;

    public static Object getValueClass(char ch2) {
        switch (ch2) {
            case '@': {
                return OBJECT_VALUE;
            }
            case ':': {
                return STRING_VALUE;
            }
            case '%': {
                return NUMBER_VALUE;
            }
            case '+': {
                return CLASS_VALUE;
            }
            case '#': {
                return DATE_VALUE;
            }
            case '<': {
                return EXISTING_FILE_VALUE;
            }
            case '>': {
                return FILE_VALUE;
            }
            case '*': {
                return FILES_VALUE;
            }
            case '/': {
                return URL_VALUE;
            }
        }
        return null;
    }

    public static boolean isValueCode(char ch2) {
        return ch2 == '@' || ch2 == ':' || ch2 == '%' || ch2 == '+' || ch2 == '#' || ch2 == '<' || ch2 == '>' || ch2 == '*' || ch2 == '/' || ch2 == '!';
    }

    public static Options parsePattern(String pattern) {
        int opt = 32;
        boolean required = false;
        Class type = null;
        Options options = new Options();
        for (int i10 = 0; i10 < pattern.length(); ++i10) {
            int ch2 = pattern.charAt(i10);
            if (!PatternOptionBuilder.isValueCode((char)ch2)) {
                if (opt != 32) {
                    Option option = Option.builder(String.valueOf((char)opt)).hasArg(type != null).required(required).type(type).build();
                    options.addOption(option);
                    required = false;
                    type = null;
                    opt = 32;
                }
                opt = ch2;
                continue;
            }
            if (ch2 == 33) {
                required = true;
                continue;
            }
            type = (Class)PatternOptionBuilder.getValueClass((char)ch2);
        }
        if (opt != 32) {
            Option option = Option.builder(String.valueOf((char)opt)).hasArg(type != null).required(required).type(type).build();
            options.addOption(option);
        }
        return options;
    }
}

