/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.util.LinkedList;
import org.apache.commons.compress.archivers.sevenz.BindPair;
import org.apache.commons.compress.archivers.sevenz.Coder;

class Folder {
    Coder[] coders;
    long totalInputStreams;
    long totalOutputStreams;
    BindPair[] bindPairs;
    long[] packedStreams;
    long[] unpackSizes;
    boolean hasCrc;
    long crc;
    int numUnpackSubStreams;

    Folder() {
    }

    Iterable<Coder> getOrderedCoders() {
        LinkedList<Coder> l10 = new LinkedList<Coder>();
        int current = (int)this.packedStreams[0];
        while (current != -1) {
            l10.addLast(this.coders[current]);
            int pair = this.findBindPairForOutStream(current);
            current = pair != -1 ? (int)this.bindPairs[pair].inIndex : -1;
        }
        return l10;
    }

    int findBindPairForInStream(int index) {
        for (int i10 = 0; i10 < this.bindPairs.length; ++i10) {
            if (this.bindPairs[i10].inIndex != (long)index) continue;
            return i10;
        }
        return -1;
    }

    int findBindPairForOutStream(int index) {
        for (int i10 = 0; i10 < this.bindPairs.length; ++i10) {
            if (this.bindPairs[i10].outIndex != (long)index) continue;
            return i10;
        }
        return -1;
    }

    long getUnpackSize() {
        if (this.totalOutputStreams == 0L) {
            return 0L;
        }
        for (int i10 = (int)this.totalOutputStreams - 1; i10 >= 0; --i10) {
            if (this.findBindPairForOutStream(i10) >= 0) continue;
            return this.unpackSizes[i10];
        }
        return 0L;
    }

    long getUnpackSizeForCoder(Coder coder) {
        if (this.coders != null) {
            for (int i10 = 0; i10 < this.coders.length; ++i10) {
                if (this.coders[i10] != coder) continue;
                return this.unpackSizes[i10];
            }
        }
        return 0L;
    }

    public String toString() {
        return "Folder with " + this.coders.length + " coders, " + this.totalInputStreams + " input streams, " + this.totalOutputStreams + " output streams, " + this.bindPairs.length + " bind pairs, " + this.packedStreams.length + " packed streams, " + this.unpackSizes.length + " unpack sizes, " + (this.hasCrc ? "with CRC " + this.crc : "without CRC") + " and " + this.numUnpackSubStreams + " unpack streams";
    }
}

