/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.sevenz.Coder;
import org.apache.commons.compress.archivers.sevenz.CoderBase;
import org.apache.commons.compress.utils.ByteUtils;
import org.apache.commons.compress.utils.FlushShieldFilterOutputStream;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.LZMAInputStream;
import org.tukaani.xz.LZMAOutputStream;

class LZMADecoder
extends CoderBase {
    LZMADecoder() {
        super(LZMA2Options.class, Number.class);
    }

    @Override
    InputStream decode(String archiveName, InputStream in2, long uncompressedLength, Coder coder, byte[] password) throws IOException {
        byte propsByte = coder.properties[0];
        int dictSize = this.getDictionarySize(coder);
        if (dictSize > 0x7FFFFFF0) {
            throw new IOException("Dictionary larger than 4GiB maximum size used in " + archiveName);
        }
        return new LZMAInputStream(in2, uncompressedLength, propsByte, dictSize);
    }

    @Override
    OutputStream encode(OutputStream out, Object opts) throws IOException {
        return new FlushShieldFilterOutputStream((OutputStream)new LZMAOutputStream(out, this.getOptions(opts), false));
    }

    @Override
    byte[] getOptionsAsProperties(Object opts) throws IOException {
        LZMA2Options options = this.getOptions(opts);
        byte props = (byte)((options.getPb() * 5 + options.getLp()) * 9 + options.getLc());
        int dictSize = options.getDictSize();
        byte[] o10 = new byte[5];
        o10[0] = props;
        ByteUtils.toLittleEndian(o10, dictSize, 1, 4);
        return o10;
    }

    @Override
    Object getOptionsFromCoder(Coder coder, InputStream in2) throws IOException {
        byte propsByte = coder.properties[0];
        int props = propsByte & 0xFF;
        int pb2 = props / 45;
        int lp2 = (props -= pb2 * 9 * 5) / 9;
        int lc2 = props - lp2 * 9;
        LZMA2Options opts = new LZMA2Options();
        opts.setPb(pb2);
        opts.setLcLp(lc2, lp2);
        opts.setDictSize(this.getDictionarySize(coder));
        return opts;
    }

    private int getDictionarySize(Coder coder) throws IllegalArgumentException {
        return (int)ByteUtils.fromLittleEndian(coder.properties, 1, 4);
    }

    private LZMA2Options getOptions(Object opts) throws IOException {
        if (opts instanceof LZMA2Options) {
            return (LZMA2Options)opts;
        }
        LZMA2Options options = new LZMA2Options();
        options.setDictSize(this.numberOptionOrDefault(opts));
        return options;
    }

    private int numberOptionOrDefault(Object opts) {
        return LZMADecoder.numberOptionOrDefault(opts, 0x800000);
    }
}

