/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.zip.CRC32;
import org.apache.commons.compress.archivers.sevenz.Archive;
import org.apache.commons.compress.archivers.sevenz.BindPair;
import org.apache.commons.compress.archivers.sevenz.BoundedSeekableByteChannelInputStream;
import org.apache.commons.compress.archivers.sevenz.Coder;
import org.apache.commons.compress.archivers.sevenz.Coders;
import org.apache.commons.compress.archivers.sevenz.Folder;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZMethod;
import org.apache.commons.compress.archivers.sevenz.SevenZMethodConfiguration;
import org.apache.commons.compress.archivers.sevenz.StartHeader;
import org.apache.commons.compress.archivers.sevenz.StreamMap;
import org.apache.commons.compress.archivers.sevenz.SubStreamsInfo;
import org.apache.commons.compress.utils.BoundedInputStream;
import org.apache.commons.compress.utils.CRC32VerifyingInputStream;
import org.apache.commons.compress.utils.IOUtils;

public class SevenZFile
implements Closeable {
    static final int SIGNATURE_HEADER_SIZE = 32;
    private final String fileName;
    private SeekableByteChannel channel;
    private final Archive archive;
    private int currentEntryIndex = -1;
    private int currentFolderIndex = -1;
    private InputStream currentFolderInputStream = null;
    private byte[] password;
    private final ArrayList<InputStream> deferredBlockStreams = new ArrayList();
    static final byte[] sevenZSignature = new byte[]{55, 122, -68, -81, 39, 28};

    public SevenZFile(File filename, byte[] password) throws IOException {
        this(Files.newByteChannel(filename.toPath(), EnumSet.of(StandardOpenOption.READ), new FileAttribute[0]), filename.getAbsolutePath(), password, true);
    }

    public SevenZFile(SeekableByteChannel channel) throws IOException {
        this(channel, "unknown archive", null);
    }

    public SevenZFile(SeekableByteChannel channel, byte[] password) throws IOException {
        this(channel, "unknown archive", password);
    }

    public SevenZFile(SeekableByteChannel channel, String filename, byte[] password) throws IOException {
        this(channel, filename, password, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SevenZFile(SeekableByteChannel channel, String filename, byte[] password, boolean closeOnError) throws IOException {
        boolean succeeded = false;
        this.channel = channel;
        this.fileName = filename;
        try {
            this.archive = this.readHeaders(password);
            if (password != null) {
                this.password = new byte[password.length];
                System.arraycopy(password, 0, this.password, 0, password.length);
            } else {
                this.password = null;
            }
            succeeded = true;
        }
        finally {
            if (!succeeded && closeOnError) {
                this.channel.close();
            }
        }
    }

    public SevenZFile(File filename) throws IOException {
        this(filename, null);
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            finally {
                this.channel = null;
                if (this.password != null) {
                    Arrays.fill(this.password, (byte)0);
                }
                this.password = null;
            }
        }
    }

    public SevenZArchiveEntry getNextEntry() throws IOException {
        if (this.currentEntryIndex >= this.archive.files.length - 1) {
            return null;
        }
        ++this.currentEntryIndex;
        SevenZArchiveEntry entry = this.archive.files[this.currentEntryIndex];
        this.buildDecodingStream();
        return entry;
    }

    public Iterable<SevenZArchiveEntry> getEntries() {
        return Arrays.asList(this.archive.files);
    }

    private Archive readHeaders(byte[] password) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(12).order(ByteOrder.LITTLE_ENDIAN);
        this.readFully(buf);
        byte[] signature = new byte[6];
        buf.get(signature);
        if (!Arrays.equals(signature, sevenZSignature)) {
            throw new IOException("Bad 7z signature");
        }
        byte archiveVersionMajor = buf.get();
        byte archiveVersionMinor = buf.get();
        if (archiveVersionMajor != 0) {
            throw new IOException(String.format("Unsupported 7z version (%d,%d)", archiveVersionMajor, archiveVersionMinor));
        }
        long startHeaderCrc = 0xFFFFFFFFL & (long)buf.getInt();
        StartHeader startHeader = this.readStartHeader(startHeaderCrc);
        int nextHeaderSizeInt = (int)startHeader.nextHeaderSize;
        if ((long)nextHeaderSizeInt != startHeader.nextHeaderSize) {
            throw new IOException("cannot handle nextHeaderSize " + startHeader.nextHeaderSize);
        }
        this.channel.position(32L + startHeader.nextHeaderOffset);
        buf = ByteBuffer.allocate(nextHeaderSizeInt).order(ByteOrder.LITTLE_ENDIAN);
        this.readFully(buf);
        CRC32 crc = new CRC32();
        crc.update(buf.array());
        if (startHeader.nextHeaderCrc != crc.getValue()) {
            throw new IOException("NextHeader CRC mismatch");
        }
        Archive archive = new Archive();
        int nid = SevenZFile.getUnsignedByte(buf);
        if (nid == 23) {
            buf = this.readEncodedHeader(buf, archive, password);
            archive = new Archive();
            nid = SevenZFile.getUnsignedByte(buf);
        }
        if (nid != 1) {
            throw new IOException("Broken or unsupported archive: no Header");
        }
        this.readHeader(buf, archive);
        return archive;
    }

    private StartHeader readStartHeader(long startHeaderCrc) throws IOException {
        StartHeader startHeader = new StartHeader();
        try (DataInputStream dataInputStream = new DataInputStream(new CRC32VerifyingInputStream((InputStream)new BoundedSeekableByteChannelInputStream(this.channel, 20L), 20L, startHeaderCrc));){
            startHeader.nextHeaderOffset = Long.reverseBytes(dataInputStream.readLong());
            startHeader.nextHeaderSize = Long.reverseBytes(dataInputStream.readLong());
            startHeader.nextHeaderCrc = 0xFFFFFFFFL & (long)Integer.reverseBytes(dataInputStream.readInt());
            StartHeader startHeader2 = startHeader;
            return startHeader2;
        }
    }

    private void readHeader(ByteBuffer header, Archive archive) throws IOException {
        int nid = SevenZFile.getUnsignedByte(header);
        if (nid == 2) {
            this.readArchiveProperties(header);
            nid = SevenZFile.getUnsignedByte(header);
        }
        if (nid == 3) {
            throw new IOException("Additional streams unsupported");
        }
        if (nid == 4) {
            this.readStreamsInfo(header, archive);
            nid = SevenZFile.getUnsignedByte(header);
        }
        if (nid == 5) {
            this.readFilesInfo(header, archive);
            nid = SevenZFile.getUnsignedByte(header);
        }
        if (nid != 0) {
            throw new IOException("Badly terminated header, found " + nid);
        }
    }

    private void readArchiveProperties(ByteBuffer input) throws IOException {
        int nid = SevenZFile.getUnsignedByte(input);
        while (nid != 0) {
            long propertySize = SevenZFile.readUint64(input);
            byte[] property = new byte[(int)propertySize];
            input.get(property);
            nid = SevenZFile.getUnsignedByte(input);
        }
    }

    private ByteBuffer readEncodedHeader(ByteBuffer header, Archive archive, byte[] password) throws IOException {
        this.readStreamsInfo(header, archive);
        Folder folder = archive.folders[0];
        boolean firstPackStreamIndex = false;
        long folderOffset = 32L + archive.packPos + 0L;
        this.channel.position(folderOffset);
        InputStream inputStreamStack = new BoundedSeekableByteChannelInputStream(this.channel, archive.packSizes[0]);
        for (Coder coder : folder.getOrderedCoders()) {
            if (coder.numInStreams != 1L || coder.numOutStreams != 1L) {
                throw new IOException("Multi input/output stream coders are not yet supported");
            }
            inputStreamStack = Coders.addDecoder(this.fileName, inputStreamStack, folder.getUnpackSizeForCoder(coder), coder, password);
        }
        if (folder.hasCrc) {
            inputStreamStack = new CRC32VerifyingInputStream(inputStreamStack, folder.getUnpackSize(), folder.crc);
        }
        byte[] nextHeader = new byte[(int)folder.getUnpackSize()];
        try (DataInputStream nextHeaderInputStream = new DataInputStream(inputStreamStack);){
            nextHeaderInputStream.readFully(nextHeader);
        }
        return ByteBuffer.wrap(nextHeader).order(ByteOrder.LITTLE_ENDIAN);
    }

    private void readStreamsInfo(ByteBuffer header, Archive archive) throws IOException {
        int nid = SevenZFile.getUnsignedByte(header);
        if (nid == 6) {
            this.readPackInfo(header, archive);
            nid = SevenZFile.getUnsignedByte(header);
        }
        if (nid == 7) {
            this.readUnpackInfo(header, archive);
            nid = SevenZFile.getUnsignedByte(header);
        } else {
            archive.folders = new Folder[0];
        }
        if (nid == 8) {
            this.readSubStreamsInfo(header, archive);
            nid = SevenZFile.getUnsignedByte(header);
        }
        if (nid != 0) {
            throw new IOException("Badly terminated StreamsInfo");
        }
    }

    private void readPackInfo(ByteBuffer header, Archive archive) throws IOException {
        int i10;
        archive.packPos = SevenZFile.readUint64(header);
        long numPackStreams = SevenZFile.readUint64(header);
        int nid = SevenZFile.getUnsignedByte(header);
        if (nid == 9) {
            archive.packSizes = new long[(int)numPackStreams];
            for (i10 = 0; i10 < archive.packSizes.length; ++i10) {
                archive.packSizes[i10] = SevenZFile.readUint64(header);
            }
            nid = SevenZFile.getUnsignedByte(header);
        }
        if (nid == 10) {
            archive.packCrcsDefined = this.readAllOrBits(header, (int)numPackStreams);
            archive.packCrcs = new long[(int)numPackStreams];
            for (i10 = 0; i10 < (int)numPackStreams; ++i10) {
                if (!archive.packCrcsDefined.get(i10)) continue;
                archive.packCrcs[i10] = 0xFFFFFFFFL & (long)header.getInt();
            }
            nid = SevenZFile.getUnsignedByte(header);
        }
        if (nid != 0) {
            throw new IOException("Badly terminated PackInfo (" + nid + ")");
        }
    }

    private void readUnpackInfo(ByteBuffer header, Archive archive) throws IOException {
        int nid = SevenZFile.getUnsignedByte(header);
        if (nid != 11) {
            throw new IOException("Expected kFolder, got " + nid);
        }
        long numFolders = SevenZFile.readUint64(header);
        Folder[] folders = new Folder[(int)numFolders];
        archive.folders = folders;
        int external = SevenZFile.getUnsignedByte(header);
        if (external != 0) {
            throw new IOException("External unsupported");
        }
        for (int i10 = 0; i10 < (int)numFolders; ++i10) {
            folders[i10] = this.readFolder(header);
        }
        nid = SevenZFile.getUnsignedByte(header);
        if (nid != 12) {
            throw new IOException("Expected kCodersUnpackSize, got " + nid);
        }
        for (Folder folder : folders) {
            folder.unpackSizes = new long[(int)folder.totalOutputStreams];
            int i11 = 0;
            while ((long)i11 < folder.totalOutputStreams) {
                folder.unpackSizes[i11] = SevenZFile.readUint64(header);
                ++i11;
            }
        }
        nid = SevenZFile.getUnsignedByte(header);
        if (nid == 10) {
            BitSet crcsDefined = this.readAllOrBits(header, (int)numFolders);
            for (int i12 = 0; i12 < (int)numFolders; ++i12) {
                if (crcsDefined.get(i12)) {
                    folders[i12].hasCrc = true;
                    folders[i12].crc = 0xFFFFFFFFL & (long)header.getInt();
                    continue;
                }
                folders[i12].hasCrc = false;
            }
            nid = SevenZFile.getUnsignedByte(header);
        }
        if (nid != 0) {
            throw new IOException("Badly terminated UnpackInfo");
        }
    }

    private void readSubStreamsInfo(ByteBuffer header, Archive archive) throws IOException {
        for (Folder folder : archive.folders) {
            folder.numUnpackSubStreams = 1;
        }
        int totalUnpackStreams = archive.folders.length;
        int nid = SevenZFile.getUnsignedByte(header);
        if (nid == 13) {
            totalUnpackStreams = 0;
            for (Folder folder : archive.folders) {
                long numStreams = SevenZFile.readUint64(header);
                folder.numUnpackSubStreams = (int)numStreams;
                totalUnpackStreams = (int)((long)totalUnpackStreams + numStreams);
            }
            nid = SevenZFile.getUnsignedByte(header);
        }
        SubStreamsInfo subStreamsInfo = new SubStreamsInfo();
        subStreamsInfo.unpackSizes = new long[totalUnpackStreams];
        subStreamsInfo.hasCrc = new BitSet(totalUnpackStreams);
        subStreamsInfo.crcs = new long[totalUnpackStreams];
        int nextUnpackStream = 0;
        for (Folder folder : archive.folders) {
            if (folder.numUnpackSubStreams == 0) continue;
            long sum = 0L;
            if (nid == 9) {
                for (int i10 = 0; i10 < folder.numUnpackSubStreams - 1; ++i10) {
                    long size = SevenZFile.readUint64(header);
                    subStreamsInfo.unpackSizes[nextUnpackStream++] = size;
                    sum += size;
                }
            }
            subStreamsInfo.unpackSizes[nextUnpackStream++] = folder.getUnpackSize() - sum;
        }
        if (nid == 9) {
            nid = SevenZFile.getUnsignedByte(header);
        }
        int numDigests = 0;
        for (Folder folder : archive.folders) {
            if (folder.numUnpackSubStreams == 1 && folder.hasCrc) continue;
            numDigests += folder.numUnpackSubStreams;
        }
        if (nid == 10) {
            BitSet hasMissingCrc = this.readAllOrBits(header, numDigests);
            long[] missingCrcs = new long[numDigests];
            for (int i11 = 0; i11 < numDigests; ++i11) {
                if (!hasMissingCrc.get(i11)) continue;
                missingCrcs[i11] = 0xFFFFFFFFL & (long)header.getInt();
            }
            int nextCrc = 0;
            int nextMissingCrc = 0;
            for (Folder folder : archive.folders) {
                if (folder.numUnpackSubStreams == 1 && folder.hasCrc) {
                    subStreamsInfo.hasCrc.set(nextCrc, true);
                    subStreamsInfo.crcs[nextCrc] = folder.crc;
                    ++nextCrc;
                    continue;
                }
                for (int i12 = 0; i12 < folder.numUnpackSubStreams; ++i12) {
                    subStreamsInfo.hasCrc.set(nextCrc, hasMissingCrc.get(nextMissingCrc));
                    subStreamsInfo.crcs[nextCrc] = missingCrcs[nextMissingCrc];
                    ++nextCrc;
                    ++nextMissingCrc;
                }
            }
            nid = SevenZFile.getUnsignedByte(header);
        }
        if (nid != 0) {
            throw new IOException("Badly terminated SubStreamsInfo");
        }
        archive.subStreamsInfo = subStreamsInfo;
    }

    private Folder readFolder(ByteBuffer header) throws IOException {
        Folder folder = new Folder();
        long numCoders = SevenZFile.readUint64(header);
        Coder[] coders = new Coder[(int)numCoders];
        long totalInStreams = 0L;
        long totalOutStreams = 0L;
        for (int i10 = 0; i10 < coders.length; ++i10) {
            coders[i10] = new Coder();
            int bits = SevenZFile.getUnsignedByte(header);
            int idSize = bits & 0xF;
            boolean isSimple = (bits & 0x10) == 0;
            boolean hasAttributes = (bits & 0x20) != 0;
            boolean moreAlternativeMethods = (bits & 0x80) != 0;
            coders[i10].decompressionMethodId = new byte[idSize];
            header.get(coders[i10].decompressionMethodId);
            if (isSimple) {
                coders[i10].numInStreams = 1L;
                coders[i10].numOutStreams = 1L;
            } else {
                coders[i10].numInStreams = SevenZFile.readUint64(header);
                coders[i10].numOutStreams = SevenZFile.readUint64(header);
            }
            totalInStreams += coders[i10].numInStreams;
            totalOutStreams += coders[i10].numOutStreams;
            if (hasAttributes) {
                long propertiesSize = SevenZFile.readUint64(header);
                coders[i10].properties = new byte[(int)propertiesSize];
                header.get(coders[i10].properties);
            }
            if (!moreAlternativeMethods) continue;
            throw new IOException("Alternative methods are unsupported, please report. The reference implementation doesn't support them either.");
        }
        folder.coders = coders;
        folder.totalInputStreams = totalInStreams;
        folder.totalOutputStreams = totalOutStreams;
        if (totalOutStreams == 0L) {
            throw new IOException("Total output streams can't be 0");
        }
        long numBindPairs = totalOutStreams - 1L;
        BindPair[] bindPairs = new BindPair[(int)numBindPairs];
        for (int i11 = 0; i11 < bindPairs.length; ++i11) {
            bindPairs[i11] = new BindPair();
            bindPairs[i11].inIndex = SevenZFile.readUint64(header);
            bindPairs[i11].outIndex = SevenZFile.readUint64(header);
        }
        folder.bindPairs = bindPairs;
        if (totalInStreams < numBindPairs) {
            throw new IOException("Total input streams can't be less than the number of bind pairs");
        }
        long numPackedStreams = totalInStreams - numBindPairs;
        long[] packedStreams = new long[(int)numPackedStreams];
        if (numPackedStreams == 1L) {
            int i12;
            for (i12 = 0; i12 < (int)totalInStreams && folder.findBindPairForInStream(i12) >= 0; ++i12) {
            }
            if (i12 == (int)totalInStreams) {
                throw new IOException("Couldn't find stream's bind pair index");
            }
            packedStreams[0] = i12;
        } else {
            for (int i13 = 0; i13 < (int)numPackedStreams; ++i13) {
                packedStreams[i13] = SevenZFile.readUint64(header);
            }
        }
        folder.packedStreams = packedStreams;
        return folder;
    }

    private BitSet readAllOrBits(ByteBuffer header, int size) throws IOException {
        BitSet bits;
        int areAllDefined = SevenZFile.getUnsignedByte(header);
        if (areAllDefined != 0) {
            bits = new BitSet(size);
            for (int i10 = 0; i10 < size; ++i10) {
                bits.set(i10, true);
            }
        } else {
            bits = this.readBits(header, size);
        }
        return bits;
    }

    private BitSet readBits(ByteBuffer header, int size) throws IOException {
        BitSet bits = new BitSet(size);
        int mask = 0;
        int cache = 0;
        for (int i10 = 0; i10 < size; ++i10) {
            if (mask == 0) {
                mask = 128;
                cache = SevenZFile.getUnsignedByte(header);
            }
            bits.set(i10, (cache & mask) != 0);
            mask >>>= 1;
        }
        return bits;
    }

    private void readFilesInfo(ByteBuffer header, Archive archive) throws IOException {
        int propertyType;
        long numFiles = SevenZFile.readUint64(header);
        SevenZArchiveEntry[] files = new SevenZArchiveEntry[(int)numFiles];
        for (int i10 = 0; i10 < files.length; ++i10) {
            files[i10] = new SevenZArchiveEntry();
        }
        BitSet isEmptyStream = null;
        BitSet isEmptyFile = null;
        BitSet isAnti = null;
        block13: while ((propertyType = SevenZFile.getUnsignedByte(header)) != 0) {
            long size = SevenZFile.readUint64(header);
            switch (propertyType) {
                case 14: {
                    isEmptyStream = this.readBits(header, files.length);
                    break;
                }
                case 15: {
                    if (isEmptyStream == null) {
                        throw new IOException("Header format error: kEmptyStream must appear before kEmptyFile");
                    }
                    isEmptyFile = this.readBits(header, isEmptyStream.cardinality());
                    break;
                }
                case 16: {
                    if (isEmptyStream == null) {
                        throw new IOException("Header format error: kEmptyStream must appear before kAnti");
                    }
                    isAnti = this.readBits(header, isEmptyStream.cardinality());
                    break;
                }
                case 17: {
                    int external = SevenZFile.getUnsignedByte(header);
                    if (external != 0) {
                        throw new IOException("Not implemented");
                    }
                    if ((size - 1L & 1L) != 0L) {
                        throw new IOException("File names length invalid");
                    }
                    byte[] names = new byte[(int)(size - 1L)];
                    header.get(names);
                    int nextFile = 0;
                    int nextName = 0;
                    for (int i11 = 0; i11 < names.length; i11 += 2) {
                        if (names[i11] != 0 || names[i11 + 1] != 0) continue;
                        files[nextFile++].setName(new String(names, nextName, i11 - nextName, "UTF-16LE"));
                        nextName = i11 + 2;
                    }
                    if (nextName == names.length && nextFile == files.length) continue block13;
                    throw new IOException("Error parsing file names");
                }
                case 18: {
                    int i12;
                    BitSet timesDefined = this.readAllOrBits(header, files.length);
                    int external = SevenZFile.getUnsignedByte(header);
                    if (external != 0) {
                        throw new IOException("Unimplemented");
                    }
                    for (i12 = 0; i12 < files.length; ++i12) {
                        files[i12].setHasCreationDate(timesDefined.get(i12));
                        if (!files[i12].getHasCreationDate()) continue;
                        files[i12].setCreationDate(header.getLong());
                    }
                    continue block13;
                }
                case 19: {
                    int i12;
                    BitSet timesDefined = this.readAllOrBits(header, files.length);
                    int external = SevenZFile.getUnsignedByte(header);
                    if (external != 0) {
                        throw new IOException("Unimplemented");
                    }
                    for (i12 = 0; i12 < files.length; ++i12) {
                        files[i12].setHasAccessDate(timesDefined.get(i12));
                        if (!files[i12].getHasAccessDate()) continue;
                        files[i12].setAccessDate(header.getLong());
                    }
                    continue block13;
                }
                case 20: {
                    int i12;
                    BitSet timesDefined = this.readAllOrBits(header, files.length);
                    int external = SevenZFile.getUnsignedByte(header);
                    if (external != 0) {
                        throw new IOException("Unimplemented");
                    }
                    for (i12 = 0; i12 < files.length; ++i12) {
                        files[i12].setHasLastModifiedDate(timesDefined.get(i12));
                        if (!files[i12].getHasLastModifiedDate()) continue;
                        files[i12].setLastModifiedDate(header.getLong());
                    }
                    continue block13;
                }
                case 21: {
                    int i12;
                    BitSet attributesDefined = this.readAllOrBits(header, files.length);
                    int external = SevenZFile.getUnsignedByte(header);
                    if (external != 0) {
                        throw new IOException("Unimplemented");
                    }
                    for (i12 = 0; i12 < files.length; ++i12) {
                        files[i12].setHasWindowsAttributes(attributesDefined.get(i12));
                        if (!files[i12].getHasWindowsAttributes()) continue;
                        files[i12].setWindowsAttributes(header.getInt());
                    }
                    continue block13;
                }
                case 24: {
                    throw new IOException("kStartPos is unsupported, please report");
                }
                case 25: {
                    if (SevenZFile.skipBytesFully(header, size) >= size) continue block13;
                    throw new IOException("Incomplete kDummy property");
                }
                default: {
                    if (SevenZFile.skipBytesFully(header, size) >= size) continue block13;
                    throw new IOException("Incomplete property of type " + propertyType);
                }
            }
        }
        int nonEmptyFileCounter = 0;
        int emptyFileCounter = 0;
        for (int i13 = 0; i13 < files.length; ++i13) {
            files[i13].setHasStream(isEmptyStream == null || !isEmptyStream.get(i13));
            if (files[i13].hasStream()) {
                files[i13].setDirectory(false);
                files[i13].setAntiItem(false);
                files[i13].setHasCrc(archive.subStreamsInfo.hasCrc.get(nonEmptyFileCounter));
                files[i13].setCrcValue(archive.subStreamsInfo.crcs[nonEmptyFileCounter]);
                files[i13].setSize(archive.subStreamsInfo.unpackSizes[nonEmptyFileCounter]);
                ++nonEmptyFileCounter;
                continue;
            }
            files[i13].setDirectory(isEmptyFile == null || !isEmptyFile.get(emptyFileCounter));
            files[i13].setAntiItem(isAnti != null && isAnti.get(emptyFileCounter));
            files[i13].setHasCrc(false);
            files[i13].setSize(0L);
            ++emptyFileCounter;
        }
        archive.files = files;
        this.calculateStreamMap(archive);
    }

    private void calculateStreamMap(Archive archive) throws IOException {
        StreamMap streamMap = new StreamMap();
        int nextFolderPackStreamIndex = 0;
        int numFolders = archive.folders != null ? archive.folders.length : 0;
        streamMap.folderFirstPackStreamIndex = new int[numFolders];
        for (int i10 = 0; i10 < numFolders; ++i10) {
            streamMap.folderFirstPackStreamIndex[i10] = nextFolderPackStreamIndex;
            nextFolderPackStreamIndex += archive.folders[i10].packedStreams.length;
        }
        long nextPackStreamOffset = 0L;
        int numPackSizes = archive.packSizes != null ? archive.packSizes.length : 0;
        streamMap.packStreamOffsets = new long[numPackSizes];
        for (int i11 = 0; i11 < numPackSizes; ++i11) {
            streamMap.packStreamOffsets[i11] = nextPackStreamOffset;
            nextPackStreamOffset += archive.packSizes[i11];
        }
        streamMap.folderFirstFileIndex = new int[numFolders];
        streamMap.fileFolderIndex = new int[archive.files.length];
        int nextFolderIndex = 0;
        int nextFolderUnpackStreamIndex = 0;
        for (int i12 = 0; i12 < archive.files.length; ++i12) {
            if (!archive.files[i12].hasStream() && nextFolderUnpackStreamIndex == 0) {
                streamMap.fileFolderIndex[i12] = -1;
                continue;
            }
            if (nextFolderUnpackStreamIndex == 0) {
                while (nextFolderIndex < archive.folders.length) {
                    streamMap.folderFirstFileIndex[nextFolderIndex] = i12;
                    if (archive.folders[nextFolderIndex].numUnpackSubStreams > 0) break;
                    ++nextFolderIndex;
                }
                if (nextFolderIndex >= archive.folders.length) {
                    throw new IOException("Too few folders in archive");
                }
            }
            streamMap.fileFolderIndex[i12] = nextFolderIndex;
            if (!archive.files[i12].hasStream() || ++nextFolderUnpackStreamIndex < archive.folders[nextFolderIndex].numUnpackSubStreams) continue;
            ++nextFolderIndex;
            nextFolderUnpackStreamIndex = 0;
        }
        archive.streamMap = streamMap;
    }

    private void buildDecodingStream() throws IOException {
        int folderIndex = this.archive.streamMap.fileFolderIndex[this.currentEntryIndex];
        if (folderIndex < 0) {
            this.deferredBlockStreams.clear();
            return;
        }
        SevenZArchiveEntry file = this.archive.files[this.currentEntryIndex];
        if (this.currentFolderIndex == folderIndex) {
            file.setContentMethods(this.archive.files[this.currentEntryIndex - 1].getContentMethods());
        } else {
            this.currentFolderIndex = folderIndex;
            this.deferredBlockStreams.clear();
            if (this.currentFolderInputStream != null) {
                this.currentFolderInputStream.close();
                this.currentFolderInputStream = null;
            }
            Folder folder = this.archive.folders[folderIndex];
            int firstPackStreamIndex = this.archive.streamMap.folderFirstPackStreamIndex[folderIndex];
            long folderOffset = 32L + this.archive.packPos + this.archive.streamMap.packStreamOffsets[firstPackStreamIndex];
            this.currentFolderInputStream = this.buildDecoderStack(folder, folderOffset, firstPackStreamIndex, file);
        }
        InputStream fileStream = new BoundedInputStream(this.currentFolderInputStream, file.getSize());
        if (file.getHasCrc()) {
            fileStream = new CRC32VerifyingInputStream(fileStream, file.getSize(), file.getCrcValue());
        }
        this.deferredBlockStreams.add(fileStream);
    }

    private InputStream buildDecoderStack(Folder folder, long folderOffset, int firstPackStreamIndex, SevenZArchiveEntry entry) throws IOException {
        this.channel.position(folderOffset);
        InputStream inputStreamStack = new BufferedInputStream(new BoundedSeekableByteChannelInputStream(this.channel, this.archive.packSizes[firstPackStreamIndex]));
        LinkedList<SevenZMethodConfiguration> methods = new LinkedList<SevenZMethodConfiguration>();
        for (Coder coder : folder.getOrderedCoders()) {
            if (coder.numInStreams != 1L || coder.numOutStreams != 1L) {
                throw new IOException("Multi input/output stream coders are not yet supported");
            }
            SevenZMethod method = SevenZMethod.byId(coder.decompressionMethodId);
            inputStreamStack = Coders.addDecoder(this.fileName, inputStreamStack, folder.getUnpackSizeForCoder(coder), coder, this.password);
            methods.addFirst(new SevenZMethodConfiguration(method, Coders.findByMethod(method).getOptionsFromCoder(coder, inputStreamStack)));
        }
        entry.setContentMethods(methods);
        if (folder.hasCrc) {
            return new CRC32VerifyingInputStream(inputStreamStack, folder.getUnpackSize(), folder.crc);
        }
        return inputStreamStack;
    }

    public int read() throws IOException {
        return this.getCurrentStream().read();
    }

    private InputStream getCurrentStream() throws IOException {
        if (this.archive.files[this.currentEntryIndex].getSize() == 0L) {
            return new ByteArrayInputStream(new byte[0]);
        }
        if (this.deferredBlockStreams.isEmpty()) {
            throw new IllegalStateException("No current 7z entry (call getNextEntry() first).");
        }
        while (this.deferredBlockStreams.size() > 1) {
            InputStream stream = this.deferredBlockStreams.remove(0);
            Throwable throwable = null;
            try {
                IOUtils.skip(stream, Long.MAX_VALUE);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                stream.close();
            }
        }
        return this.deferredBlockStreams.get(0);
    }

    public int read(byte[] b10) throws IOException {
        return this.read(b10, 0, b10.length);
    }

    public int read(byte[] b10, int off, int len) throws IOException {
        return this.getCurrentStream().read(b10, off, len);
    }

    private static long readUint64(ByteBuffer in2) throws IOException {
        long firstByte = SevenZFile.getUnsignedByte(in2);
        int mask = 128;
        long value = 0L;
        for (int i10 = 0; i10 < 8; ++i10) {
            if ((firstByte & (long)mask) == 0L) {
                return value | (firstByte & (long)(mask - 1)) << 8 * i10;
            }
            long nextByte = SevenZFile.getUnsignedByte(in2);
            value |= nextByte << 8 * i10;
            mask >>>= 1;
        }
        return value;
    }

    private static int getUnsignedByte(ByteBuffer buf) {
        return buf.get() & 0xFF;
    }

    public static boolean matches(byte[] signature, int length) {
        if (length < sevenZSignature.length) {
            return false;
        }
        for (int i10 = 0; i10 < sevenZSignature.length; ++i10) {
            if (signature[i10] == sevenZSignature[i10]) continue;
            return false;
        }
        return true;
    }

    private static long skipBytesFully(ByteBuffer input, long bytesToSkip) throws IOException {
        if (bytesToSkip < 1L) {
            return 0L;
        }
        int current = input.position();
        int maxSkip = input.remaining();
        if ((long)maxSkip < bytesToSkip) {
            bytesToSkip = maxSkip;
        }
        input.position(current + (int)bytesToSkip);
        return bytesToSkip;
    }

    private void readFully(ByteBuffer buf) throws IOException {
        buf.rewind();
        IOUtils.readFully(this.channel, buf);
        buf.flip();
    }

    public String toString() {
        return this.archive.toString();
    }
}

