/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.compress.archivers.zip.BitStream;

class BinaryTree {
    private static final int UNDEFINED = -1;
    private static final int NODE = -2;
    private final int[] tree;

    public BinaryTree(int depth) {
        this.tree = new int[(1 << depth + 1) - 1];
        Arrays.fill(this.tree, -1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addLeaf(int node, int path, int depth, int value) {
        if (depth == 0) {
            if (this.tree[node] != -1) throw new IllegalArgumentException("Tree value at index " + node + " has already been assigned (" + this.tree[node] + ")");
            this.tree[node] = value;
            return;
        } else {
            this.tree[node] = -2;
            int nextChild = 2 * node + 1 + (path & 1);
            this.addLeaf(nextChild, path >>> 1, depth - 1, value);
        }
    }

    public int read(BitStream stream) throws IOException {
        int value;
        int bit;
        int currentIndex = 0;
        while (true) {
            if ((bit = stream.nextBit()) == -1) {
                return -1;
            }
            int childIndex = 2 * currentIndex + 1 + bit;
            value = this.tree[childIndex];
            if (value != -2) break;
            currentIndex = childIndex;
        }
        if (value != -1) {
            return value;
        }
        throw new IOException("The child " + bit + " of node at index " + currentIndex + " is not defined");
    }

    static BinaryTree decode(InputStream in2, int totalNumberOfValues) throws IOException {
        int size = in2.read() + 1;
        if (size == 0) {
            throw new IOException("Cannot read the size of the encoded tree, unexpected end of stream");
        }
        byte[] encodedTree = new byte[size];
        new DataInputStream(in2).readFully(encodedTree);
        int maxLength = 0;
        int[] originalBitLengths = new int[totalNumberOfValues];
        int pos = 0;
        for (byte b10 : encodedTree) {
            int numberOfValues = ((b10 & 0xF0) >> 4) + 1;
            int bitLength = (b10 & 0xF) + 1;
            for (int j10 = 0; j10 < numberOfValues; ++j10) {
                originalBitLengths[pos++] = bitLength;
            }
            maxLength = Math.max(maxLength, bitLength);
        }
        int[] permutation = new int[originalBitLengths.length];
        for (int k10 = 0; k10 < permutation.length; ++k10) {
            permutation[k10] = k10;
        }
        int c10 = 0;
        int[] sortedBitLengths = new int[originalBitLengths.length];
        for (int k11 = 0; k11 < originalBitLengths.length; ++k11) {
            for (int l10 = 0; l10 < originalBitLengths.length; ++l10) {
                if (originalBitLengths[l10] != k11) continue;
                sortedBitLengths[c10] = k11;
                permutation[c10] = l10;
                ++c10;
            }
        }
        int code = 0;
        int codeIncrement = 0;
        int lastBitLength = 0;
        int[] codes = new int[totalNumberOfValues];
        for (int i10 = totalNumberOfValues - 1; i10 >= 0; --i10) {
            code += codeIncrement;
            if (sortedBitLengths[i10] != lastBitLength) {
                lastBitLength = sortedBitLengths[i10];
                codeIncrement = 1 << 16 - lastBitLength;
            }
            codes[permutation[i10]] = code;
        }
        BinaryTree tree = new BinaryTree(maxLength);
        for (int k12 = 0; k12 < codes.length; ++k12) {
            int bitLength = originalBitLengths[k12];
            if (bitLength <= 0) continue;
            tree.addLeaf(0, Integer.reverse(codes[k12] << 16), bitLength, k12);
        }
        return tree;
    }
}

