/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;

class Simple8BitZipEncoding
implements ZipEncoding {
    private final char[] highChars;
    private final List<Simple8BitChar> reverseMapping;

    public Simple8BitZipEncoding(char[] highChars) {
        this.highChars = (char[])highChars.clone();
        ArrayList<Simple8BitChar> temp = new ArrayList<Simple8BitChar>(this.highChars.length);
        byte code = 127;
        for (char highChar : this.highChars) {
            code = (byte)(code + 1);
            temp.add(new Simple8BitChar(code, highChar));
        }
        Collections.sort(temp);
        this.reverseMapping = Collections.unmodifiableList(temp);
    }

    public char decodeByte(byte b10) {
        if (b10 >= 0) {
            return (char)b10;
        }
        return this.highChars[128 + b10];
    }

    public boolean canEncodeChar(char c10) {
        if (c10 >= '\u0000' && c10 < '\u0080') {
            return true;
        }
        Simple8BitChar r10 = this.encodeHighChar(c10);
        return r10 != null;
    }

    public boolean pushEncodedChar(ByteBuffer bb2, char c10) {
        if (c10 >= '\u0000' && c10 < '\u0080') {
            bb2.put((byte)c10);
            return true;
        }
        Simple8BitChar r10 = this.encodeHighChar(c10);
        if (r10 == null) {
            return false;
        }
        bb2.put(r10.code);
        return true;
    }

    private Simple8BitChar encodeHighChar(char c10) {
        int i02 = 0;
        int i12 = this.reverseMapping.size();
        while (i12 > i02) {
            int i10 = i02 + (i12 - i02) / 2;
            Simple8BitChar m10 = this.reverseMapping.get(i10);
            if (m10.unicode == c10) {
                return m10;
            }
            if (m10.unicode < c10) {
                i02 = i10 + 1;
                continue;
            }
            i12 = i10;
        }
        if (i02 >= this.reverseMapping.size()) {
            return null;
        }
        Simple8BitChar r10 = this.reverseMapping.get(i02);
        if (r10.unicode != c10) {
            return null;
        }
        return r10;
    }

    @Override
    public boolean canEncode(String name) {
        for (int i10 = 0; i10 < name.length(); ++i10) {
            char c10 = name.charAt(i10);
            if (this.canEncodeChar(c10)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ByteBuffer encode(String name) {
        ByteBuffer out = ByteBuffer.allocate(name.length() + 6 + (name.length() + 1) / 2);
        for (int i10 = 0; i10 < name.length(); ++i10) {
            char c10 = name.charAt(i10);
            if (out.remaining() < 6) {
                out = ZipEncodingHelper.growBuffer(out, out.position() + 6);
            }
            if (this.pushEncodedChar(out, c10)) continue;
            ZipEncodingHelper.appendSurrogate(out, c10);
        }
        out.limit(out.position());
        out.rewind();
        return out;
    }

    @Override
    public String decode(byte[] data) throws IOException {
        char[] ret = new char[data.length];
        for (int i10 = 0; i10 < data.length; ++i10) {
            ret[i10] = this.decodeByte(data[i10]);
        }
        return new String(ret);
    }

    private static final class Simple8BitChar
    implements Comparable<Simple8BitChar> {
        public final char unicode;
        public final byte code;

        Simple8BitChar(byte code, char unicode) {
            this.code = code;
            this.unicode = unicode;
        }

        @Override
        public int compareTo(Simple8BitChar a10) {
            return this.unicode - a10.unicode;
        }

        public String toString() {
            return "0x" + Integer.toHexString(0xFFFF & this.unicode) + "->0x" + Integer.toHexString(0xFF & this.code);
        }

        public boolean equals(Object o10) {
            if (o10 instanceof Simple8BitChar) {
                Simple8BitChar other = (Simple8BitChar)o10;
                return this.unicode == other.unicode && this.code == other.code;
            }
            return false;
        }

        public int hashCode() {
            return this.unicode;
        }
    }
}

