/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.zip.CRC32;
import org.apache.commons.compress.archivers.zip.AbstractUnicodeExtraField;
import org.apache.commons.compress.archivers.zip.UnicodeCommentExtraField;
import org.apache.commons.compress.archivers.zip.UnicodePathExtraField;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.apache.commons.compress.archivers.zip.ZipMethod;

public abstract class ZipUtil {
    private static final byte[] DOS_TIME_MIN = ZipLong.getBytes(8448L);

    public static ZipLong toDosTime(Date time) {
        return new ZipLong(ZipUtil.toDosTime(time.getTime()));
    }

    public static byte[] toDosTime(long t10) {
        byte[] result = new byte[4];
        ZipUtil.toDosTime(t10, result, 0);
        return result;
    }

    public static void toDosTime(long t10, byte[] buf, int offset) {
        ZipUtil.toDosTime(Calendar.getInstance(), t10, buf, offset);
    }

    static void toDosTime(Calendar c10, long t10, byte[] buf, int offset) {
        c10.setTimeInMillis(t10);
        int year = c10.get(1);
        if (year < 1980) {
            System.arraycopy(DOS_TIME_MIN, 0, buf, offset, DOS_TIME_MIN.length);
            return;
        }
        int month = c10.get(2) + 1;
        long value = year - 1980 << 25 | month << 21 | c10.get(5) << 16 | c10.get(11) << 11 | c10.get(12) << 5 | c10.get(13) >> 1;
        ZipLong.putLong(value, buf, offset);
    }

    public static long adjustToLong(int i10) {
        if (i10 < 0) {
            return 0x100000000L + (long)i10;
        }
        return i10;
    }

    public static byte[] reverse(byte[] array) {
        int z10 = array.length - 1;
        for (int i10 = 0; i10 < array.length / 2; ++i10) {
            byte x10 = array[i10];
            array[i10] = array[z10 - i10];
            array[z10 - i10] = x10;
        }
        return array;
    }

    static long bigToLong(BigInteger big) {
        if (big.bitLength() <= 63) {
            return big.longValue();
        }
        throw new NumberFormatException("The BigInteger cannot fit inside a 64 bit java long: [" + big + "]");
    }

    static BigInteger longToBig(long l10) {
        if (l10 < Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Negative longs < -2^31 not permitted: [" + l10 + "]");
        }
        if (l10 < 0L && l10 >= Integer.MIN_VALUE) {
            l10 = ZipUtil.adjustToLong((int)l10);
        }
        return BigInteger.valueOf(l10);
    }

    public static int signedByteToUnsignedInt(byte b10) {
        if (b10 >= 0) {
            return b10;
        }
        return 256 + b10;
    }

    public static byte unsignedIntToSignedByte(int i10) {
        if (i10 > 255 || i10 < 0) {
            throw new IllegalArgumentException("Can only convert non-negative integers between [0,255] to byte: [" + i10 + "]");
        }
        if (i10 < 128) {
            return (byte)i10;
        }
        return (byte)(i10 - 256);
    }

    public static Date fromDosTime(ZipLong zipDosTime) {
        long dosTime = zipDosTime.getValue();
        return new Date(ZipUtil.dosToJavaTime(dosTime));
    }

    public static long dosToJavaTime(long dosTime) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, (int)(dosTime >> 25 & 0x7FL) + 1980);
        cal.set(2, (int)(dosTime >> 21 & 0xFL) - 1);
        cal.set(5, (int)(dosTime >> 16) & 0x1F);
        cal.set(11, (int)(dosTime >> 11) & 0x1F);
        cal.set(12, (int)(dosTime >> 5) & 0x3F);
        cal.set(13, (int)(dosTime << 1) & 0x3E);
        cal.set(14, 0);
        return cal.getTime().getTime();
    }

    static void setNameAndCommentFromExtraFields(ZipArchiveEntry ze2, byte[] originalNameBytes, byte[] commentBytes) {
        UnicodeCommentExtraField cmt;
        String newComment;
        UnicodePathExtraField name = (UnicodePathExtraField)ze2.getExtraField(UnicodePathExtraField.UPATH_ID);
        String originalName = ze2.getName();
        String newName = ZipUtil.getUnicodeStringIfOriginalMatches(name, originalNameBytes);
        if (newName != null && !originalName.equals(newName)) {
            ze2.setName(newName);
        }
        if (commentBytes != null && commentBytes.length > 0 && (newComment = ZipUtil.getUnicodeStringIfOriginalMatches(cmt = (UnicodeCommentExtraField)ze2.getExtraField(UnicodeCommentExtraField.UCOM_ID), commentBytes)) != null) {
            ze2.setComment(newComment);
        }
    }

    private static String getUnicodeStringIfOriginalMatches(AbstractUnicodeExtraField f10, byte[] orig) {
        if (f10 != null) {
            CRC32 crc32 = new CRC32();
            crc32.update(orig);
            long origCRC32 = crc32.getValue();
            if (origCRC32 == f10.getNameCRC32()) {
                try {
                    return ZipEncodingHelper.UTF8_ZIP_ENCODING.decode(f10.getUnicodeName());
                }
                catch (IOException ex2) {
                    return null;
                }
            }
        }
        return null;
    }

    static byte[] copy(byte[] from) {
        if (from != null) {
            byte[] to2 = new byte[from.length];
            System.arraycopy(from, 0, to2, 0, to2.length);
            return to2;
        }
        return null;
    }

    static void copy(byte[] from, byte[] to2, int offset) {
        if (from != null) {
            System.arraycopy(from, 0, to2, offset, from.length);
        }
    }

    static boolean canHandleEntryData(ZipArchiveEntry entry) {
        return ZipUtil.supportsEncryptionOf(entry) && ZipUtil.supportsMethodOf(entry);
    }

    private static boolean supportsEncryptionOf(ZipArchiveEntry entry) {
        return !entry.getGeneralPurposeBit().usesEncryption();
    }

    private static boolean supportsMethodOf(ZipArchiveEntry entry) {
        return entry.getMethod() == 0 || entry.getMethod() == ZipMethod.UNSHRINKING.getCode() || entry.getMethod() == ZipMethod.IMPLODING.getCode() || entry.getMethod() == 8 || entry.getMethod() == ZipMethod.BZIP2.getCode();
    }

    static void checkRequestedFeatures(ZipArchiveEntry ze2) throws UnsupportedZipFeatureException {
        if (!ZipUtil.supportsEncryptionOf(ze2)) {
            throw new UnsupportedZipFeatureException(UnsupportedZipFeatureException.Feature.ENCRYPTION, ze2);
        }
        if (!ZipUtil.supportsMethodOf(ze2)) {
            ZipMethod m10 = ZipMethod.getMethodByCode(ze2.getMethod());
            if (m10 == null) {
                throw new UnsupportedZipFeatureException(UnsupportedZipFeatureException.Feature.METHOD, ze2);
            }
            throw new UnsupportedZipFeatureException(m10, ze2);
        }
    }
}

