/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class FileNameUtil {
    private final Map<String, String> compressSuffix = new HashMap<String, String>();
    private final Map<String, String> uncompressSuffix;
    private final int longestCompressedSuffix;
    private final int shortestCompressedSuffix;
    private final int longestUncompressedSuffix;
    private final int shortestUncompressedSuffix;
    private final String defaultExtension;

    public FileNameUtil(Map<String, String> uncompressSuffix, String defaultExtension) {
        this.uncompressSuffix = Collections.unmodifiableMap(uncompressSuffix);
        int lc2 = Integer.MIN_VALUE;
        int sc2 = Integer.MAX_VALUE;
        int lu2 = Integer.MIN_VALUE;
        int su2 = Integer.MAX_VALUE;
        for (Map.Entry<String, String> ent : uncompressSuffix.entrySet()) {
            String u10;
            int ul2;
            int cl2 = ent.getKey().length();
            if (cl2 > lc2) {
                lc2 = cl2;
            }
            if (cl2 < sc2) {
                sc2 = cl2;
            }
            if ((ul2 = (u10 = ent.getValue()).length()) <= 0) continue;
            if (!this.compressSuffix.containsKey(u10)) {
                this.compressSuffix.put(u10, ent.getKey());
            }
            if (ul2 > lu2) {
                lu2 = ul2;
            }
            if (ul2 >= su2) continue;
            su2 = ul2;
        }
        this.longestCompressedSuffix = lc2;
        this.longestUncompressedSuffix = lu2;
        this.shortestCompressedSuffix = sc2;
        this.shortestUncompressedSuffix = su2;
        this.defaultExtension = defaultExtension;
    }

    public boolean isCompressedFilename(String filename) {
        String lower = filename.toLowerCase(Locale.ENGLISH);
        int n10 = lower.length();
        for (int i10 = this.shortestCompressedSuffix; i10 <= this.longestCompressedSuffix && i10 < n10; ++i10) {
            if (!this.uncompressSuffix.containsKey(lower.substring(n10 - i10))) continue;
            return true;
        }
        return false;
    }

    public String getUncompressedFilename(String filename) {
        String lower = filename.toLowerCase(Locale.ENGLISH);
        int n10 = lower.length();
        for (int i10 = this.shortestCompressedSuffix; i10 <= this.longestCompressedSuffix && i10 < n10; ++i10) {
            String suffix = this.uncompressSuffix.get(lower.substring(n10 - i10));
            if (suffix == null) continue;
            return filename.substring(0, n10 - i10) + suffix;
        }
        return filename;
    }

    public String getCompressedFilename(String filename) {
        String lower = filename.toLowerCase(Locale.ENGLISH);
        int n10 = lower.length();
        for (int i10 = this.shortestUncompressedSuffix; i10 <= this.longestUncompressedSuffix && i10 < n10; ++i10) {
            String suffix = this.compressSuffix.get(lower.substring(n10 - i10));
            if (suffix == null) continue;
            return filename.substring(0, n10 - i10) + suffix;
        }
        return filename + this.defaultExtension;
    }
}

