/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.bzip2;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2Constants;
import org.apache.commons.compress.compressors.bzip2.CRC;
import org.apache.commons.compress.compressors.bzip2.Rand;
import org.apache.commons.compress.utils.BitInputStream;
import org.apache.commons.compress.utils.CloseShieldFilterInputStream;

public class BZip2CompressorInputStream
extends CompressorInputStream
implements BZip2Constants {
    private int last;
    private int origPtr;
    private int blockSize100k;
    private boolean blockRandomised;
    private final CRC crc = new CRC();
    private int nInUse;
    private BitInputStream bin;
    private final boolean decompressConcatenated;
    private static final int EOF = 0;
    private static final int START_BLOCK_STATE = 1;
    private static final int RAND_PART_A_STATE = 2;
    private static final int RAND_PART_B_STATE = 3;
    private static final int RAND_PART_C_STATE = 4;
    private static final int NO_RAND_PART_A_STATE = 5;
    private static final int NO_RAND_PART_B_STATE = 6;
    private static final int NO_RAND_PART_C_STATE = 7;
    private int currentState = 1;
    private int storedBlockCRC;
    private int storedCombinedCRC;
    private int computedBlockCRC;
    private int computedCombinedCRC;
    private int su_count;
    private int su_ch2;
    private int su_chPrev;
    private int su_i2;
    private int su_j2;
    private int su_rNToGo;
    private int su_rTPos;
    private int su_tPos;
    private char su_z;
    private Data data;

    public BZip2CompressorInputStream(InputStream in2) throws IOException {
        this(in2, false);
    }

    public BZip2CompressorInputStream(InputStream in2, boolean decompressConcatenated) throws IOException {
        this.bin = new BitInputStream(in2 == System.in ? new CloseShieldFilterInputStream(in2) : in2, ByteOrder.BIG_ENDIAN);
        this.decompressConcatenated = decompressConcatenated;
        this.init(true);
        this.initBlock();
    }

    @Override
    public int read() throws IOException {
        if (this.bin != null) {
            int r10 = this.read0();
            this.count(r10 < 0 ? -1 : 1);
            return r10;
        }
        throw new IOException("stream closed");
    }

    @Override
    public int read(byte[] dest, int offs, int len) throws IOException {
        int b10;
        if (offs < 0) {
            throw new IndexOutOfBoundsException("offs(" + offs + ") < 0.");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("len(" + len + ") < 0.");
        }
        if (offs + len > dest.length) {
            throw new IndexOutOfBoundsException("offs(" + offs + ") + len(" + len + ") > dest.length(" + dest.length + ").");
        }
        if (this.bin == null) {
            throw new IOException("stream closed");
        }
        if (len == 0) {
            return 0;
        }
        int hi2 = offs + len;
        int destOffs = offs;
        while (destOffs < hi2 && (b10 = this.read0()) >= 0) {
            dest[destOffs++] = (byte)b10;
            this.count(1);
        }
        int c10 = destOffs == offs ? -1 : destOffs - offs;
        return c10;
    }

    private void makeMaps() {
        boolean[] inUse = this.data.inUse;
        byte[] seqToUnseq = this.data.seqToUnseq;
        int nInUseShadow = 0;
        for (int i10 = 0; i10 < 256; ++i10) {
            if (!inUse[i10]) continue;
            seqToUnseq[nInUseShadow++] = (byte)i10;
        }
        this.nInUse = nInUseShadow;
    }

    private int read0() throws IOException {
        switch (this.currentState) {
            case 0: {
                return -1;
            }
            case 1: {
                return this.setupBlock();
            }
            case 2: {
                throw new IllegalStateException();
            }
            case 3: {
                return this.setupRandPartB();
            }
            case 4: {
                return this.setupRandPartC();
            }
            case 5: {
                throw new IllegalStateException();
            }
            case 6: {
                return this.setupNoRandPartB();
            }
            case 7: {
                return this.setupNoRandPartC();
            }
        }
        throw new IllegalStateException();
    }

    private int readNextByte(BitInputStream in2) throws IOException {
        long b10 = in2.readBits(8);
        return (int)b10;
    }

    private boolean init(boolean isFirstStream) throws IOException {
        int magic0;
        if (null == this.bin) {
            throw new IOException("No InputStream");
        }
        if (!isFirstStream) {
            this.bin.clearBitCache();
        }
        if ((magic0 = this.readNextByte(this.bin)) == -1 && !isFirstStream) {
            return false;
        }
        int magic1 = this.readNextByte(this.bin);
        int magic2 = this.readNextByte(this.bin);
        if (magic0 != 66 || magic1 != 90 || magic2 != 104) {
            throw new IOException(isFirstStream ? "Stream is not in the BZip2 format" : "Garbage after a valid BZip2 stream");
        }
        int blockSize = this.readNextByte(this.bin);
        if (blockSize < 49 || blockSize > 57) {
            throw new IOException("BZip2 block size is invalid");
        }
        this.blockSize100k = blockSize - 48;
        this.computedCombinedCRC = 0;
        return true;
    }

    private void initBlock() throws IOException {
        char magic5;
        char magic4;
        char magic3;
        char magic2;
        char magic1;
        char magic0;
        BitInputStream bin;
        block3: {
            bin = this.bin;
            do {
                magic0 = BZip2CompressorInputStream.bsGetUByte(bin);
                magic1 = BZip2CompressorInputStream.bsGetUByte(bin);
                magic2 = BZip2CompressorInputStream.bsGetUByte(bin);
                magic3 = BZip2CompressorInputStream.bsGetUByte(bin);
                magic4 = BZip2CompressorInputStream.bsGetUByte(bin);
                magic5 = BZip2CompressorInputStream.bsGetUByte(bin);
                if (magic0 != '\u0017' || magic1 != 'r' || magic2 != 'E' || magic3 != '8' || magic4 != 'P' || magic5 != '\u0090') break block3;
            } while (!this.complete());
            return;
        }
        if (magic0 != '1' || magic1 != 'A' || magic2 != 'Y' || magic3 != '&' || magic4 != 'S' || magic5 != 'Y') {
            this.currentState = 0;
            throw new IOException("bad block header");
        }
        this.storedBlockCRC = BZip2CompressorInputStream.bsGetInt(bin);
        boolean bl2 = this.blockRandomised = BZip2CompressorInputStream.bsR(bin, 1) == 1;
        if (this.data == null) {
            this.data = new Data(this.blockSize100k);
        }
        this.getAndMoveToFrontDecode();
        this.crc.initialiseCRC();
        this.currentState = 1;
    }

    private void endBlock() throws IOException {
        this.computedBlockCRC = this.crc.getFinalCRC();
        if (this.storedBlockCRC != this.computedBlockCRC) {
            this.computedCombinedCRC = this.storedCombinedCRC << 1 | this.storedCombinedCRC >>> 31;
            this.computedCombinedCRC ^= this.storedBlockCRC;
            throw new IOException("BZip2 CRC error");
        }
        this.computedCombinedCRC = this.computedCombinedCRC << 1 | this.computedCombinedCRC >>> 31;
        this.computedCombinedCRC ^= this.computedBlockCRC;
    }

    private boolean complete() throws IOException {
        this.storedCombinedCRC = BZip2CompressorInputStream.bsGetInt(this.bin);
        this.currentState = 0;
        this.data = null;
        if (this.storedCombinedCRC != this.computedCombinedCRC) {
            throw new IOException("BZip2 CRC error");
        }
        return !this.decompressConcatenated || !this.init(false);
    }

    @Override
    public void close() throws IOException {
        BitInputStream inShadow = this.bin;
        if (inShadow != null) {
            try {
                inShadow.close();
            }
            finally {
                this.data = null;
                this.bin = null;
            }
        }
    }

    private static int bsR(BitInputStream bin, int n10) throws IOException {
        long thech = bin.readBits(n10);
        if (thech < 0L) {
            throw new IOException("unexpected end of stream");
        }
        return (int)thech;
    }

    private static boolean bsGetBit(BitInputStream bin) throws IOException {
        return BZip2CompressorInputStream.bsR(bin, 1) != 0;
    }

    private static char bsGetUByte(BitInputStream bin) throws IOException {
        return (char)BZip2CompressorInputStream.bsR(bin, 8);
    }

    private static int bsGetInt(BitInputStream bin) throws IOException {
        return BZip2CompressorInputStream.bsR(bin, 32);
    }

    private static void hbCreateDecodeTables(int[] limit, int[] base, int[] perm, char[] length, int minLen, int maxLen, int alphaSize) {
        int i10;
        int pp2 = 0;
        for (i10 = minLen; i10 <= maxLen; ++i10) {
            for (int j10 = 0; j10 < alphaSize; ++j10) {
                if (length[j10] != i10) continue;
                perm[pp2++] = j10;
            }
        }
        i10 = 23;
        while (--i10 > 0) {
            base[i10] = 0;
            limit[i10] = 0;
        }
        for (i10 = 0; i10 < alphaSize; ++i10) {
            int n10 = length[i10] + '\u0001';
            base[n10] = base[n10] + 1;
        }
        int b10 = base[0];
        for (i10 = 1; i10 < 23; ++i10) {
            base[i10] = b10 += base[i10];
        }
        int vec = 0;
        int b11 = base[i10];
        for (i10 = minLen; i10 <= maxLen; ++i10) {
            int nb2 = base[i10 + 1];
            b11 = nb2;
            limit[i10] = (vec += nb2 - b11) - 1;
            vec <<= 1;
        }
        for (i10 = minLen + 1; i10 <= maxLen; ++i10) {
            base[i10] = (limit[i10 - 1] + 1 << 1) - base[i10];
        }
    }

    private void recvDecodingTables() throws IOException {
        int i10;
        int i11;
        BitInputStream bin = this.bin;
        Data dataShadow = this.data;
        boolean[] inUse = dataShadow.inUse;
        byte[] pos = dataShadow.recvDecodingTables_pos;
        byte[] selector = dataShadow.selector;
        byte[] selectorMtf = dataShadow.selectorMtf;
        int inUse16 = 0;
        for (i11 = 0; i11 < 16; ++i11) {
            if (!BZip2CompressorInputStream.bsGetBit(bin)) continue;
            inUse16 |= 1 << i11;
        }
        Arrays.fill(inUse, false);
        for (i11 = 0; i11 < 16; ++i11) {
            if ((inUse16 & 1 << i11) == 0) continue;
            int i16 = i11 << 4;
            for (int j10 = 0; j10 < 16; ++j10) {
                if (!BZip2CompressorInputStream.bsGetBit(bin)) continue;
                inUse[i16 + j10] = true;
            }
        }
        this.makeMaps();
        int alphaSize = this.nInUse + 2;
        int nGroups = BZip2CompressorInputStream.bsR(bin, 3);
        int nSelectors = BZip2CompressorInputStream.bsR(bin, 15);
        for (i10 = 0; i10 < nSelectors; ++i10) {
            int j11 = 0;
            while (BZip2CompressorInputStream.bsGetBit(bin)) {
                ++j11;
            }
            selectorMtf[i10] = (byte)j11;
        }
        int v10 = nGroups;
        while (--v10 >= 0) {
            pos[v10] = (byte)v10;
        }
        for (i10 = 0; i10 < nSelectors; ++i10) {
            int v11;
            byte tmp = pos[v11];
            for (v11 = selectorMtf[i10] & 0xFF; v11 > 0; --v11) {
                pos[v11] = pos[v11 - 1];
            }
            pos[0] = tmp;
            selector[i10] = tmp;
        }
        char[][] len = dataShadow.temp_charArray2d;
        for (int t10 = 0; t10 < nGroups; ++t10) {
            int curr = BZip2CompressorInputStream.bsR(bin, 5);
            char[] len_t = len[t10];
            for (int i12 = 0; i12 < alphaSize; ++i12) {
                while (BZip2CompressorInputStream.bsGetBit(bin)) {
                    curr += BZip2CompressorInputStream.bsGetBit(bin) ? -1 : 1;
                }
                len_t[i12] = (char)curr;
            }
        }
        this.createHuffmanDecodingTables(alphaSize, nGroups);
    }

    private void createHuffmanDecodingTables(int alphaSize, int nGroups) {
        Data dataShadow = this.data;
        char[][] len = dataShadow.temp_charArray2d;
        int[] minLens = dataShadow.minLens;
        int[][] limit = dataShadow.limit;
        int[][] base = dataShadow.base;
        int[][] perm = dataShadow.perm;
        for (int t10 = 0; t10 < nGroups; ++t10) {
            int minLen = 32;
            int maxLen = 0;
            char[] len_t = len[t10];
            int i10 = alphaSize;
            while (--i10 >= 0) {
                int lent = len_t[i10];
                if (lent > maxLen) {
                    maxLen = lent;
                }
                if (lent >= minLen) continue;
                minLen = lent;
            }
            BZip2CompressorInputStream.hbCreateDecodeTables(limit[t10], base[t10], perm[t10], len[t10], minLen, maxLen, alphaSize);
            minLens[t10] = minLen;
        }
    }

    private void getAndMoveToFrontDecode() throws IOException {
        BitInputStream bin = this.bin;
        this.origPtr = BZip2CompressorInputStream.bsR(bin, 24);
        this.recvDecodingTables();
        Data dataShadow = this.data;
        byte[] ll8 = dataShadow.ll8;
        int[] unzftab = dataShadow.unzftab;
        byte[] selector = dataShadow.selector;
        byte[] seqToUnseq = dataShadow.seqToUnseq;
        char[] yy2 = dataShadow.getAndMoveToFrontDecode_yy;
        int[] minLens = dataShadow.minLens;
        int[][] limit = dataShadow.limit;
        int[][] base = dataShadow.base;
        int[][] perm = dataShadow.perm;
        int limitLast = this.blockSize100k * 100000;
        int i10 = 256;
        while (--i10 >= 0) {
            yy2[i10] = (char)i10;
            unzftab[i10] = 0;
        }
        int groupNo = 0;
        int groupPos = 49;
        int eob = this.nInUse + 1;
        int nextSym = this.getAndMoveToFrontDecode0(0);
        int lastShadow = -1;
        int zt2 = selector[groupNo] & 0xFF;
        int[] base_zt = base[zt2];
        int[] limit_zt = limit[zt2];
        int[] perm_zt = perm[zt2];
        int minLens_zt = minLens[zt2];
        while (nextSym != eob) {
            if (nextSym == 0 || nextSym == 1) {
                int s10 = -1;
                int n10 = 1;
                while (true) {
                    if (nextSym == 0) {
                        s10 += n10;
                    } else {
                        if (nextSym != 1) break;
                        s10 += n10 << 1;
                    }
                    if (groupPos == 0) {
                        groupPos = 49;
                        zt2 = selector[++groupNo] & 0xFF;
                        base_zt = base[zt2];
                        limit_zt = limit[zt2];
                        perm_zt = perm[zt2];
                        minLens_zt = minLens[zt2];
                    } else {
                        --groupPos;
                    }
                    int zn2 = minLens_zt;
                    int zvec = BZip2CompressorInputStream.bsR(bin, zn2);
                    while (zvec > limit_zt[zn2]) {
                        ++zn2;
                        zvec = zvec << 1 | BZip2CompressorInputStream.bsR(bin, 1);
                    }
                    nextSym = perm_zt[zvec - base_zt[zn2]];
                    n10 <<= 1;
                }
                byte ch2 = seqToUnseq[yy2[0]];
                int n11 = ch2 & 0xFF;
                unzftab[n11] = unzftab[n11] + (s10 + 1);
                while (s10-- >= 0) {
                    ll8[++lastShadow] = ch2;
                }
                if (lastShadow < limitLast) continue;
                throw new IOException("block overrun");
            }
            if (++lastShadow >= limitLast) {
                throw new IOException("block overrun");
            }
            char tmp = yy2[nextSym - 1];
            int n12 = seqToUnseq[tmp] & 0xFF;
            unzftab[n12] = unzftab[n12] + 1;
            ll8[lastShadow] = seqToUnseq[tmp];
            if (nextSym <= 16) {
                int j10 = nextSym - 1;
                while (j10 > 0) {
                    yy2[j10--] = yy2[j10];
                }
            } else {
                System.arraycopy(yy2, 0, yy2, 1, nextSym - 1);
            }
            yy2[0] = tmp;
            if (groupPos == 0) {
                groupPos = 49;
                zt2 = selector[++groupNo] & 0xFF;
                base_zt = base[zt2];
                limit_zt = limit[zt2];
                perm_zt = perm[zt2];
                minLens_zt = minLens[zt2];
            } else {
                --groupPos;
            }
            int zn3 = minLens_zt;
            int zvec = BZip2CompressorInputStream.bsR(bin, zn3);
            while (zvec > limit_zt[zn3]) {
                ++zn3;
                zvec = zvec << 1 | BZip2CompressorInputStream.bsR(bin, 1);
            }
            nextSym = perm_zt[zvec - base_zt[zn3]];
        }
        this.last = lastShadow;
    }

    private int getAndMoveToFrontDecode0(int groupNo) throws IOException {
        Data dataShadow = this.data;
        int zt2 = dataShadow.selector[groupNo] & 0xFF;
        int[] limit_zt = dataShadow.limit[zt2];
        int zn2 = dataShadow.minLens[zt2];
        int zvec = BZip2CompressorInputStream.bsR(this.bin, zn2);
        while (zvec > limit_zt[zn2]) {
            ++zn2;
            zvec = zvec << 1 | BZip2CompressorInputStream.bsR(this.bin, 1);
        }
        return dataShadow.perm[zt2][zvec - dataShadow.base[zt2][zn2]];
    }

    private int setupBlock() throws IOException {
        int i10;
        if (this.currentState == 0 || this.data == null) {
            return -1;
        }
        int[] cftab = this.data.cftab;
        int[] tt2 = this.data.initTT(this.last + 1);
        byte[] ll8 = this.data.ll8;
        cftab[0] = 0;
        System.arraycopy(this.data.unzftab, 0, cftab, 1, 256);
        int c10 = cftab[0];
        for (i10 = 1; i10 <= 256; ++i10) {
            cftab[i10] = c10 += cftab[i10];
        }
        i10 = 0;
        int lastShadow = this.last;
        while (i10 <= lastShadow) {
            int n10 = ll8[i10] & 0xFF;
            int n11 = cftab[n10];
            cftab[n10] = n11 + 1;
            tt2[n11] = i10++;
        }
        if (this.origPtr < 0 || this.origPtr >= tt2.length) {
            throw new IOException("stream corrupted");
        }
        this.su_tPos = tt2[this.origPtr];
        this.su_count = 0;
        this.su_i2 = 0;
        this.su_ch2 = 256;
        if (this.blockRandomised) {
            this.su_rNToGo = 0;
            this.su_rTPos = 0;
            return this.setupRandPartA();
        }
        return this.setupNoRandPartA();
    }

    private int setupRandPartA() throws IOException {
        if (this.su_i2 <= this.last) {
            this.su_chPrev = this.su_ch2;
            int su_ch2Shadow = this.data.ll8[this.su_tPos] & 0xFF;
            this.su_tPos = this.data.tt[this.su_tPos];
            if (this.su_rNToGo == 0) {
                this.su_rNToGo = Rand.rNums(this.su_rTPos) - 1;
                if (++this.su_rTPos == 512) {
                    this.su_rTPos = 0;
                }
            } else {
                --this.su_rNToGo;
            }
            this.su_ch2 = su_ch2Shadow ^= this.su_rNToGo == 1 ? 1 : 0;
            ++this.su_i2;
            this.currentState = 3;
            this.crc.updateCRC(su_ch2Shadow);
            return su_ch2Shadow;
        }
        this.endBlock();
        this.initBlock();
        return this.setupBlock();
    }

    private int setupNoRandPartA() throws IOException {
        if (this.su_i2 <= this.last) {
            int su_ch2Shadow;
            this.su_chPrev = this.su_ch2;
            this.su_ch2 = su_ch2Shadow = this.data.ll8[this.su_tPos] & 0xFF;
            this.su_tPos = this.data.tt[this.su_tPos];
            ++this.su_i2;
            this.currentState = 6;
            this.crc.updateCRC(su_ch2Shadow);
            return su_ch2Shadow;
        }
        this.currentState = 5;
        this.endBlock();
        this.initBlock();
        return this.setupBlock();
    }

    private int setupRandPartB() throws IOException {
        if (this.su_ch2 != this.su_chPrev) {
            this.currentState = 2;
            this.su_count = 1;
            return this.setupRandPartA();
        }
        if (++this.su_count >= 4) {
            this.su_z = (char)(this.data.ll8[this.su_tPos] & 0xFF);
            this.su_tPos = this.data.tt[this.su_tPos];
            if (this.su_rNToGo == 0) {
                this.su_rNToGo = Rand.rNums(this.su_rTPos) - 1;
                if (++this.su_rTPos == 512) {
                    this.su_rTPos = 0;
                }
            } else {
                --this.su_rNToGo;
            }
            this.su_j2 = 0;
            this.currentState = 4;
            if (this.su_rNToGo == 1) {
                this.su_z = (char)(this.su_z ^ '\u0001');
            }
            return this.setupRandPartC();
        }
        this.currentState = 2;
        return this.setupRandPartA();
    }

    private int setupRandPartC() throws IOException {
        if (this.su_j2 < this.su_z) {
            this.crc.updateCRC(this.su_ch2);
            ++this.su_j2;
            return this.su_ch2;
        }
        this.currentState = 2;
        ++this.su_i2;
        this.su_count = 0;
        return this.setupRandPartA();
    }

    private int setupNoRandPartB() throws IOException {
        if (this.su_ch2 != this.su_chPrev) {
            this.su_count = 1;
            return this.setupNoRandPartA();
        }
        if (++this.su_count >= 4) {
            this.su_z = (char)(this.data.ll8[this.su_tPos] & 0xFF);
            this.su_tPos = this.data.tt[this.su_tPos];
            this.su_j2 = 0;
            return this.setupNoRandPartC();
        }
        return this.setupNoRandPartA();
    }

    private int setupNoRandPartC() throws IOException {
        if (this.su_j2 < this.su_z) {
            int su_ch2Shadow = this.su_ch2;
            this.crc.updateCRC(su_ch2Shadow);
            ++this.su_j2;
            this.currentState = 7;
            return su_ch2Shadow;
        }
        ++this.su_i2;
        this.su_count = 0;
        return this.setupNoRandPartA();
    }

    public static boolean matches(byte[] signature, int length) {
        if (length < 3) {
            return false;
        }
        if (signature[0] != 66) {
            return false;
        }
        if (signature[1] != 90) {
            return false;
        }
        return signature[2] == 104;
    }

    private static final class Data {
        final boolean[] inUse = new boolean[256];
        final byte[] seqToUnseq = new byte[256];
        final byte[] selector = new byte[18002];
        final byte[] selectorMtf = new byte[18002];
        final int[] unzftab = new int[256];
        final int[][] limit = new int[6][258];
        final int[][] base = new int[6][258];
        final int[][] perm = new int[6][258];
        final int[] minLens = new int[6];
        final int[] cftab = new int[257];
        final char[] getAndMoveToFrontDecode_yy = new char[256];
        final char[][] temp_charArray2d = new char[6][258];
        final byte[] recvDecodingTables_pos = new byte[6];
        int[] tt;
        byte[] ll8;

        Data(int blockSize100k) {
            this.ll8 = new byte[blockSize100k * 100000];
        }

        int[] initTT(int length) {
            int[] ttShadow = this.tt;
            if (ttShadow == null || ttShadow.length < length) {
                this.tt = ttShadow = new int[length];
            }
            return ttShadow;
        }
    }
}

