/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.bzip2;

import java.util.BitSet;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

class BlockSort {
    private static final int QSORT_STACK_SIZE = 1000;
    private static final int FALLBACK_QSORT_STACK_SIZE = 100;
    private static final int STACK_SIZE = 1000;
    private int workDone;
    private int workLimit;
    private boolean firstAttempt;
    private final int[] stack_ll = new int[1000];
    private final int[] stack_hh = new int[1000];
    private final int[] stack_dd = new int[1000];
    private final int[] mainSort_runningOrder = new int[256];
    private final int[] mainSort_copy = new int[256];
    private final boolean[] mainSort_bigDone = new boolean[256];
    private final int[] ftab = new int[65537];
    private final char[] quadrant;
    private static final int FALLBACK_QSORT_SMALL_THRESH = 10;
    private int[] eclass;
    private static final int[] INCS = new int[]{1, 4, 13, 40, 121, 364, 1093, 3280, 9841, 29524, 88573, 265720, 797161, 2391484};
    private static final int SMALL_THRESH = 20;
    private static final int DEPTH_THRESH = 10;
    private static final int WORK_FACTOR = 30;
    private static final int SETMASK = 0x200000;
    private static final int CLEARMASK = -2097153;

    BlockSort(BZip2CompressorOutputStream.Data data) {
        this.quadrant = data.sfmap;
    }

    void blockSort(BZip2CompressorOutputStream.Data data, int last) {
        this.workLimit = 30 * last;
        this.workDone = 0;
        this.firstAttempt = true;
        if (last + 1 < 10000) {
            this.fallbackSort(data, last);
        } else {
            this.mainSort(data, last);
            if (this.firstAttempt && this.workDone > this.workLimit) {
                this.fallbackSort(data, last);
            }
        }
        int[] fmap = data.fmap;
        data.origPtr = -1;
        for (int i10 = 0; i10 <= last; ++i10) {
            if (fmap[i10] != 0) continue;
            data.origPtr = i10;
            break;
        }
    }

    final void fallbackSort(BZip2CompressorOutputStream.Data data, int last) {
        data.block[0] = data.block[last + 1];
        this.fallbackSort(data.fmap, data.block, last + 1);
        int i10 = 0;
        while (i10 < last + 1) {
            int n10 = i10++;
            data.fmap[n10] = data.fmap[n10] - 1;
        }
        for (i10 = 0; i10 < last + 1; ++i10) {
            if (data.fmap[i10] != -1) continue;
            data.fmap[i10] = last;
            break;
        }
    }

    private void fallbackSimpleSort(int[] fmap, int[] eclass, int lo2, int hi2) {
        int j10;
        int ec_tmp;
        int tmp;
        int i10;
        if (lo2 == hi2) {
            return;
        }
        if (hi2 - lo2 > 3) {
            for (i10 = hi2 - 4; i10 >= lo2; --i10) {
                tmp = fmap[i10];
                ec_tmp = eclass[tmp];
                for (j10 = i10 + 4; j10 <= hi2 && ec_tmp > eclass[fmap[j10]]; j10 += 4) {
                    fmap[j10 - 4] = fmap[j10];
                }
                fmap[j10 - 4] = tmp;
            }
        }
        for (i10 = hi2 - 1; i10 >= lo2; --i10) {
            tmp = fmap[i10];
            ec_tmp = eclass[tmp];
            for (j10 = i10 + 1; j10 <= hi2 && ec_tmp > eclass[fmap[j10]]; ++j10) {
                fmap[j10 - 1] = fmap[j10];
            }
            fmap[j10 - 1] = tmp;
        }
    }

    private void fswap(int[] fmap, int zz1, int zz2) {
        int zztmp = fmap[zz1];
        fmap[zz1] = fmap[zz2];
        fmap[zz2] = zztmp;
    }

    private void fvswap(int[] fmap, int yyp1, int yyp2, int yyn) {
        while (yyn > 0) {
            this.fswap(fmap, yyp1, yyp2);
            ++yyp1;
            ++yyp2;
            --yyn;
        }
    }

    private int fmin(int a10, int b10) {
        return a10 < b10 ? a10 : b10;
    }

    private void fpush(int sp2, int lz2, int hz2) {
        this.stack_ll[sp2] = lz2;
        this.stack_hh[sp2] = hz2;
    }

    private int[] fpop(int sp2) {
        return new int[]{this.stack_ll[sp2], this.stack_hh[sp2]};
    }

    private void fallbackQSort3(int[] fmap, int[] eclass, int loSt, int hiSt) {
        long r10 = 0L;
        int sp2 = 0;
        this.fpush(sp2++, loSt, hiSt);
        while (sp2 > 0) {
            int n10;
            int gtHi;
            int ltLo;
            int lo2;
            int[] s10;
            int hi2;
            if ((hi2 = (s10 = this.fpop(--sp2))[1]) - (lo2 = s10[0]) < 10) {
                this.fallbackSimpleSort(fmap, eclass, lo2, hi2);
                continue;
            }
            long r32 = (r10 = (r10 * 7621L + 1L) % 32768L) % 3L;
            long med = r32 == 0L ? (long)eclass[fmap[lo2]] : (r32 == 1L ? (long)eclass[fmap[lo2 + hi2 >>> 1]] : (long)eclass[fmap[hi2]]);
            int unLo = ltLo = lo2;
            int unHi = gtHi = hi2;
            while (true) {
                if (unLo <= unHi) {
                    n10 = eclass[fmap[unLo]] - (int)med;
                    if (n10 == 0) {
                        this.fswap(fmap, unLo, ltLo);
                        ++ltLo;
                        ++unLo;
                        continue;
                    }
                    if (n10 <= 0) {
                        ++unLo;
                        continue;
                    }
                }
                while (unLo <= unHi) {
                    n10 = eclass[fmap[unHi]] - (int)med;
                    if (n10 == 0) {
                        this.fswap(fmap, unHi, gtHi);
                        --gtHi;
                        --unHi;
                        continue;
                    }
                    if (n10 < 0) break;
                    --unHi;
                }
                if (unLo > unHi) break;
                this.fswap(fmap, unLo, unHi);
                ++unLo;
                --unHi;
            }
            if (gtHi < ltLo) continue;
            n10 = this.fmin(ltLo - lo2, unLo - ltLo);
            this.fvswap(fmap, lo2, unLo - n10, n10);
            int m10 = this.fmin(hi2 - gtHi, gtHi - unHi);
            this.fvswap(fmap, unHi + 1, hi2 - m10 + 1, m10);
            n10 = lo2 + unLo - ltLo - 1;
            m10 = hi2 - (gtHi - unHi) + 1;
            if (n10 - lo2 > hi2 - m10) {
                this.fpush(sp2++, lo2, n10);
                this.fpush(sp2++, m10, hi2);
                continue;
            }
            this.fpush(sp2++, m10, hi2);
            this.fpush(sp2++, lo2, n10);
        }
    }

    private int[] getEclass() {
        if (this.eclass == null) {
            this.eclass = new int[this.quadrant.length / 2];
        }
        return this.eclass;
    }

    /*
     * Unable to fully structure code
     */
    final void fallbackSort(int[] fmap, byte[] block, int nblock) {
        ftab = new int[257];
        eclass = this.getEclass();
        for (i = 0; i < nblock; ++i) {
            eclass[i] = 0;
        }
        for (i = 0; i < nblock; ++i) {
            v0 = block[i] & 255;
            ftab[v0] = ftab[v0] + 1;
        }
        for (i = 1; i < 257; ++i) {
            v1 = i;
            ftab[v1] = ftab[v1] + ftab[i - 1];
        }
        i = 0;
        while (i < nblock) {
            j = block[i] & 255;
            ftab[j] = k = ftab[j] - 1;
            fmap[k] = i++;
        }
        nBhtab = 64 + nblock;
        bhtab = new BitSet(nBhtab);
        for (i = 0; i < 256; ++i) {
            bhtab.set(ftab[i]);
        }
        for (i = 0; i < 32; ++i) {
            bhtab.set(nblock + 2 * i);
            bhtab.clear(nblock + 2 * i + 1);
        }
        H = 1;
        block6: do {
            j = 0;
            for (i = 0; i < nblock; ++i) {
                if (bhtab.get(i)) {
                    j = i;
                }
                if ((k = fmap[i] - H) < 0) {
                    k += nblock;
                }
                eclass[k] = j;
            }
            nNotDone = 0;
            r = -1;
            block8: while (true) {
                k = r + 1;
                l = (k = bhtab.nextClearBit(k)) - 1;
                if (l >= nblock || (r = (k = bhtab.nextSetBit(k + 1)) - 1) >= nblock) continue block6;
                if (r <= l) continue;
                nNotDone += r - l + 1;
                this.fallbackQSort3(fmap, eclass, l, r);
                cc = -1;
                i = l;
                while (true) {
                    if (i <= r) ** break;
                    continue block8;
                    cc1 = eclass[fmap[i]];
                    if (cc != cc1) {
                        bhtab.set(i);
                        cc = cc1;
                    }
                    ++i;
                }
                break;
            }
        } while ((H *= 2) <= nblock && nNotDone != 0);
    }

    private boolean mainSimpleSort(BZip2CompressorOutputStream.Data dataShadow, int lo2, int hi2, int d10, int lastShadow) {
        int bigN = hi2 - lo2 + 1;
        if (bigN < 2) {
            return this.firstAttempt && this.workDone > this.workLimit;
        }
        int hp2 = 0;
        while (INCS[hp2] < bigN) {
            ++hp2;
        }
        int[] fmap = dataShadow.fmap;
        char[] quadrant = this.quadrant;
        byte[] block = dataShadow.block;
        int lastPlus1 = lastShadow + 1;
        boolean firstAttemptShadow = this.firstAttempt;
        int workLimitShadow = this.workLimit;
        int workDoneShadow = this.workDone;
        block1: while (--hp2 >= 0) {
            int h10 = INCS[hp2];
            int mj2 = lo2 + h10 - 1;
            int i10 = lo2 + h10;
            while (i10 <= hi2) {
                int k10 = 3;
                while (i10 <= hi2 && --k10 >= 0) {
                    int v10 = fmap[i10];
                    int vd2 = v10 + d10;
                    int j10 = i10;
                    boolean onceRunned = false;
                    int a10 = 0;
                    block4: while (true) {
                        int i22;
                        int i12;
                        if (onceRunned) {
                            fmap[j10] = a10;
                            if ((j10 -= h10) <= mj2) {
                                break;
                            }
                        } else {
                            onceRunned = true;
                        }
                        if (block[(i12 = (a10 = fmap[j10 - h10]) + d10) + 1] == block[(i22 = vd2) + 1]) {
                            if (block[i12 + 2] == block[i22 + 2]) {
                                if (block[i12 + 3] == block[i22 + 3]) {
                                    if (block[i12 + 4] == block[i22 + 4]) {
                                        if (block[i12 + 5] == block[i22 + 5]) {
                                            if (block[i12 += 6] == block[i22 += 6]) {
                                                int x10 = lastShadow;
                                                while (x10 > 0) {
                                                    x10 -= 4;
                                                    if (block[i12 + 1] == block[i22 + 1]) {
                                                        if (quadrant[i12] == quadrant[i22]) {
                                                            if (block[i12 + 2] == block[i22 + 2]) {
                                                                if (quadrant[i12 + 1] == quadrant[i22 + 1]) {
                                                                    if (block[i12 + 3] == block[i22 + 3]) {
                                                                        if (quadrant[i12 + 2] == quadrant[i22 + 2]) {
                                                                            if (block[i12 + 4] == block[i22 + 4]) {
                                                                                if (quadrant[i12 + 3] == quadrant[i22 + 3]) {
                                                                                    if ((i12 += 4) >= lastPlus1) {
                                                                                        i12 -= lastPlus1;
                                                                                    }
                                                                                    if ((i22 += 4) >= lastPlus1) {
                                                                                        i22 -= lastPlus1;
                                                                                    }
                                                                                    ++workDoneShadow;
                                                                                    continue;
                                                                                }
                                                                                if (quadrant[i12 + 3] <= quadrant[i22 + 3]) break block4;
                                                                                continue block4;
                                                                            }
                                                                            if ((block[i12 + 4] & 0xFF) <= (block[i22 + 4] & 0xFF)) break block4;
                                                                            continue block4;
                                                                        }
                                                                        if (quadrant[i12 + 2] <= quadrant[i22 + 2]) break block4;
                                                                        continue block4;
                                                                    }
                                                                    if ((block[i12 + 3] & 0xFF) <= (block[i22 + 3] & 0xFF)) break block4;
                                                                    continue block4;
                                                                }
                                                                if (quadrant[i12 + 1] <= quadrant[i22 + 1]) break block4;
                                                                continue block4;
                                                            }
                                                            if ((block[i12 + 2] & 0xFF) <= (block[i22 + 2] & 0xFF)) break block4;
                                                            continue block4;
                                                        }
                                                        if (quadrant[i12] <= quadrant[i22]) break block4;
                                                        continue block4;
                                                    }
                                                    if ((block[i12 + 1] & 0xFF) <= (block[i22 + 1] & 0xFF)) break block4;
                                                    continue block4;
                                                }
                                                break;
                                            }
                                            if ((block[i12] & 0xFF) <= (block[i22] & 0xFF)) break;
                                            continue;
                                        }
                                        if ((block[i12 + 5] & 0xFF) <= (block[i22 + 5] & 0xFF)) break;
                                        continue;
                                    }
                                    if ((block[i12 + 4] & 0xFF) <= (block[i22 + 4] & 0xFF)) break;
                                    continue;
                                }
                                if ((block[i12 + 3] & 0xFF) <= (block[i22 + 3] & 0xFF)) break;
                                continue;
                            }
                            if ((block[i12 + 2] & 0xFF) <= (block[i22 + 2] & 0xFF)) break;
                            continue;
                        }
                        if ((block[i12 + 1] & 0xFF) <= (block[i22 + 1] & 0xFF)) break;
                    }
                    fmap[j10] = v10;
                    ++i10;
                }
                if (!firstAttemptShadow || i10 > hi2 || workDoneShadow <= workLimitShadow) continue;
                break block1;
            }
        }
        this.workDone = workDoneShadow;
        return firstAttemptShadow && workDoneShadow > workLimitShadow;
    }

    private static void vswap(int[] fmap, int p12, int p22, int n10) {
        n10 += p12;
        while (p12 < n10) {
            int t10 = fmap[p12];
            fmap[p12++] = fmap[p22];
            fmap[p22++] = t10;
        }
    }

    private static byte med3(byte a10, byte b10, byte c10) {
        return a10 < b10 ? (b10 < c10 ? b10 : (a10 < c10 ? c10 : a10)) : (b10 > c10 ? b10 : (a10 > c10 ? c10 : a10));
    }

    private void mainQSort3(BZip2CompressorOutputStream.Data dataShadow, int loSt, int hiSt, int dSt, int last) {
        int[] stack_ll = this.stack_ll;
        int[] stack_hh = this.stack_hh;
        int[] stack_dd = this.stack_dd;
        int[] fmap = dataShadow.fmap;
        byte[] block = dataShadow.block;
        stack_ll[0] = loSt;
        stack_hh[0] = hiSt;
        stack_dd[0] = dSt;
        int sp2 = 1;
        while (--sp2 >= 0) {
            int n10;
            int lo2 = stack_ll[sp2];
            int hi2 = stack_hh[sp2];
            int d10 = stack_dd[sp2];
            if (hi2 - lo2 < 20 || d10 > 10) {
                if (!this.mainSimpleSort(dataShadow, lo2, hi2, d10, last)) continue;
                return;
            }
            int d12 = d10 + 1;
            int med = BlockSort.med3(block[fmap[lo2] + d12], block[fmap[hi2] + d12], block[fmap[lo2 + hi2 >>> 1] + d12]) & 0xFF;
            int unLo = lo2;
            int unHi = hi2;
            int ltLo = lo2;
            int gtHi = hi2;
            while (true) {
                int temp;
                if (unLo <= unHi) {
                    n10 = (block[fmap[unLo] + d12] & 0xFF) - med;
                    if (n10 == 0) {
                        temp = fmap[unLo];
                        fmap[unLo++] = fmap[ltLo];
                        fmap[ltLo++] = temp;
                        continue;
                    }
                    if (n10 < 0) {
                        ++unLo;
                        continue;
                    }
                }
                while (unLo <= unHi) {
                    n10 = (block[fmap[unHi] + d12] & 0xFF) - med;
                    if (n10 == 0) {
                        temp = fmap[unHi];
                        fmap[unHi--] = fmap[gtHi];
                        fmap[gtHi--] = temp;
                        continue;
                    }
                    if (n10 <= 0) break;
                    --unHi;
                }
                if (unLo > unHi) break;
                int temp2 = fmap[unLo];
                fmap[unLo++] = fmap[unHi];
                fmap[unHi--] = temp2;
            }
            if (gtHi < ltLo) {
                stack_ll[sp2] = lo2;
                stack_hh[sp2] = hi2;
                stack_dd[sp2] = d12;
                ++sp2;
                continue;
            }
            n10 = ltLo - lo2 < unLo - ltLo ? ltLo - lo2 : unLo - ltLo;
            BlockSort.vswap(fmap, lo2, unLo - n10, n10);
            int m10 = hi2 - gtHi < gtHi - unHi ? hi2 - gtHi : gtHi - unHi;
            BlockSort.vswap(fmap, unLo, hi2 - m10 + 1, m10);
            n10 = lo2 + unLo - ltLo - 1;
            m10 = hi2 - (gtHi - unHi) + 1;
            stack_ll[sp2] = lo2;
            stack_hh[sp2] = n10;
            stack_dd[sp2] = d10;
            stack_ll[++sp2] = n10 + 1;
            stack_hh[sp2] = m10 - 1;
            stack_dd[sp2] = d12;
            stack_ll[++sp2] = m10;
            stack_hh[sp2] = hi2;
            stack_dd[sp2] = d10;
            ++sp2;
        }
    }

    final void mainSort(BZip2CompressorOutputStream.Data dataShadow, int lastShadow) {
        int j10;
        int c22;
        int i10;
        int[] runningOrder = this.mainSort_runningOrder;
        int[] copy = this.mainSort_copy;
        boolean[] bigDone = this.mainSort_bigDone;
        int[] ftab = this.ftab;
        byte[] block = dataShadow.block;
        int[] fmap = dataShadow.fmap;
        char[] quadrant = this.quadrant;
        int workLimitShadow = this.workLimit;
        boolean firstAttemptShadow = this.firstAttempt;
        int i11 = 65537;
        while (--i11 >= 0) {
            ftab[i11] = 0;
        }
        for (i11 = 0; i11 < 20; ++i11) {
            block[lastShadow + i11 + 2] = block[i11 % (lastShadow + 1) + 1];
        }
        i11 = lastShadow + 20 + 1;
        while (--i11 >= 0) {
            quadrant[i11] = '\u0000';
        }
        block[0] = block[lastShadow + 1];
        int c12 = block[0] & 0xFF;
        for (i10 = 0; i10 <= lastShadow; ++i10) {
            c22 = block[i10 + 1] & 0xFF;
            int n10 = (c12 << 8) + c22;
            ftab[n10] = ftab[n10] + 1;
            c12 = c22;
        }
        for (i10 = 1; i10 <= 65536; ++i10) {
            int n11 = i10;
            ftab[n11] = ftab[n11] + ftab[i10 - 1];
        }
        c12 = block[1] & 0xFF;
        i10 = 0;
        while (i10 < lastShadow) {
            c22 = block[i10 + 2] & 0xFF;
            int n12 = (c12 << 8) + c22;
            int n13 = ftab[n12] - 1;
            ftab[n12] = n13;
            fmap[n13] = i10++;
            c12 = c22;
        }
        int n14 = ((block[lastShadow + 1] & 0xFF) << 8) + (block[1] & 0xFF);
        int n15 = ftab[n14] - 1;
        ftab[n14] = n15;
        fmap[n15] = lastShadow;
        i10 = 256;
        while (--i10 >= 0) {
            bigDone[i10] = false;
            runningOrder[i10] = i10;
        }
        int h10 = 364;
        while (h10 != 1) {
            for (int i12 = h10 /= 3; i12 <= 255; ++i12) {
                int vv2 = runningOrder[i12];
                int a10 = ftab[vv2 + 1 << 8] - ftab[vv2 << 8];
                int b10 = h10 - 1;
                j10 = i12;
                int ro2 = runningOrder[j10 - h10];
                while (ftab[ro2 + 1 << 8] - ftab[ro2 << 8] > a10) {
                    runningOrder[j10] = ro2;
                    if ((j10 -= h10) <= b10) break;
                    ro2 = runningOrder[j10 - h10];
                }
                runningOrder[j10] = vv2;
            }
        }
        for (i10 = 0; i10 <= 255; ++i10) {
            int j11;
            int ss2 = runningOrder[i10];
            for (j11 = 0; j11 <= 255; ++j11) {
                int sb2 = (ss2 << 8) + j11;
                int ftab_sb = ftab[sb2];
                if ((ftab_sb & 0x200000) == 0x200000) continue;
                int hi2 = (ftab[sb2 + 1] & 0xFFDFFFFF) - 1;
                int lo2 = ftab_sb & 0xFFDFFFFF;
                if (hi2 > lo2) {
                    this.mainQSort3(dataShadow, lo2, hi2, 2, lastShadow);
                    if (firstAttemptShadow && this.workDone > workLimitShadow) {
                        return;
                    }
                }
                ftab[sb2] = ftab_sb | 0x200000;
            }
            for (j11 = 0; j11 <= 255; ++j11) {
                copy[j11] = ftab[(j11 << 8) + ss2] & 0xFFDFFFFF;
            }
            int hj2 = ftab[ss2 + 1 << 8] & 0xFFDFFFFF;
            for (j11 = ftab[ss2 << 8] & 0xFFDFFFFF; j11 < hj2; ++j11) {
                int fmap_j = fmap[j11];
                c12 = block[fmap_j] & 0xFF;
                if (bigDone[c12]) continue;
                fmap[copy[c12]] = fmap_j == 0 ? lastShadow : fmap_j - 1;
                int n16 = c12;
                copy[n16] = copy[n16] + 1;
            }
            j11 = 256;
            while (--j11 >= 0) {
                int n17 = (j11 << 8) + ss2;
                ftab[n17] = ftab[n17] | 0x200000;
            }
            bigDone[ss2] = true;
            if (i10 >= 255) continue;
            int bbStart = ftab[ss2 << 8] & 0xFFDFFFFF;
            int bbSize = (ftab[ss2 + 1 << 8] & 0xFFDFFFFF) - bbStart;
            int shifts = 0;
            while (bbSize >> shifts > 65534) {
                ++shifts;
            }
            for (j10 = 0; j10 < bbSize; ++j10) {
                char qVal;
                int a2update = fmap[bbStart + j10];
                quadrant[a2update] = qVal = (char)(j10 >> shifts);
                if (a2update >= 20) continue;
                quadrant[a2update + lastShadow + 1] = qVal;
            }
        }
    }
}

