/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.commons.compress.archivers.ArchiveEntry;

public class ArchiveUtils {
    private static final int MAX_SANITIZED_NAME_LENGTH = 255;

    private ArchiveUtils() {
    }

    public static String toString(ArchiveEntry entry) {
        StringBuilder sb2 = new StringBuilder();
        sb2.append(entry.isDirectory() ? (char)'d' : '-');
        String size = Long.toString(entry.getSize());
        sb2.append(' ');
        for (int i10 = 7; i10 > size.length(); --i10) {
            sb2.append(' ');
        }
        sb2.append(size);
        sb2.append(' ').append(entry.getName());
        return sb2.toString();
    }

    public static boolean matchAsciiBuffer(String expected, byte[] buffer, int offset, int length) {
        byte[] buffer1;
        try {
            buffer1 = expected.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e10) {
            throw new RuntimeException(e10);
        }
        return ArchiveUtils.isEqual(buffer1, 0, buffer1.length, buffer, offset, length, false);
    }

    public static boolean matchAsciiBuffer(String expected, byte[] buffer) {
        return ArchiveUtils.matchAsciiBuffer(expected, buffer, 0, buffer.length);
    }

    public static byte[] toAsciiBytes(String inputString) {
        try {
            return inputString.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e10) {
            throw new RuntimeException(e10);
        }
    }

    public static String toAsciiString(byte[] inputBytes) {
        try {
            return new String(inputBytes, "US-ASCII");
        }
        catch (UnsupportedEncodingException e10) {
            throw new RuntimeException(e10);
        }
    }

    public static String toAsciiString(byte[] inputBytes, int offset, int length) {
        try {
            return new String(inputBytes, offset, length, "US-ASCII");
        }
        catch (UnsupportedEncodingException e10) {
            throw new RuntimeException(e10);
        }
    }

    public static boolean isEqual(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2, boolean ignoreTrailingNulls) {
        int i10;
        int minLen = length1 < length2 ? length1 : length2;
        for (i10 = 0; i10 < minLen; ++i10) {
            if (buffer1[offset1 + i10] == buffer2[offset2 + i10]) continue;
            return false;
        }
        if (length1 == length2) {
            return true;
        }
        if (ignoreTrailingNulls) {
            if (length1 > length2) {
                for (i10 = length2; i10 < length1; ++i10) {
                    if (buffer1[offset1 + i10] == 0) continue;
                    return false;
                }
            } else {
                for (i10 = length1; i10 < length2; ++i10) {
                    if (buffer2[offset2 + i10] == 0) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isEqual(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
        return ArchiveUtils.isEqual(buffer1, offset1, length1, buffer2, offset2, length2, false);
    }

    public static boolean isEqual(byte[] buffer1, byte[] buffer2) {
        return ArchiveUtils.isEqual(buffer1, 0, buffer1.length, buffer2, 0, buffer2.length, false);
    }

    public static boolean isEqual(byte[] buffer1, byte[] buffer2, boolean ignoreTrailingNulls) {
        return ArchiveUtils.isEqual(buffer1, 0, buffer1.length, buffer2, 0, buffer2.length, ignoreTrailingNulls);
    }

    public static boolean isEqualWithNull(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
        return ArchiveUtils.isEqual(buffer1, offset1, length1, buffer2, offset2, length2, true);
    }

    public static boolean isArrayZero(byte[] a10, int size) {
        for (int i10 = 0; i10 < size; ++i10) {
            if (a10[i10] == 0) continue;
            return false;
        }
        return true;
    }

    public static String sanitize(String s10) {
        char[] chars;
        char[] cs2 = s10.toCharArray();
        char[] cArray = chars = cs2.length <= 255 ? cs2 : Arrays.copyOf(cs2, 255);
        if (cs2.length > 255) {
            for (int i10 = 252; i10 < 255; ++i10) {
                chars[i10] = 46;
            }
        }
        StringBuilder sb2 = new StringBuilder();
        for (char c10 : chars) {
            Character.UnicodeBlock block;
            if (!Character.isISOControl(c10) && (block = Character.UnicodeBlock.of(c10)) != null && block != Character.UnicodeBlock.SPECIALS) {
                sb2.append(c10);
                continue;
            }
            sb2.append('?');
        }
        return sb2.toString();
    }
}

