/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ByteUtils {
    private ByteUtils() {
    }

    public static long fromLittleEndian(byte[] bytes) {
        return ByteUtils.fromLittleEndian(bytes, 0, bytes.length);
    }

    public static long fromLittleEndian(byte[] bytes, int off, int length) {
        ByteUtils.checkReadLength(length);
        long l10 = 0L;
        for (int i10 = 0; i10 < length; ++i10) {
            l10 |= ((long)bytes[off + i10] & 0xFFL) << 8 * i10;
        }
        return l10;
    }

    public static long fromLittleEndian(InputStream in2, int length) throws IOException {
        ByteUtils.checkReadLength(length);
        long l10 = 0L;
        for (int i10 = 0; i10 < length; ++i10) {
            long b10 = in2.read();
            if (b10 == -1L) {
                throw new IOException("premature end of data");
            }
            l10 |= b10 << i10 * 8;
        }
        return l10;
    }

    public static long fromLittleEndian(ByteSupplier supplier, int length) throws IOException {
        ByteUtils.checkReadLength(length);
        long l10 = 0L;
        for (int i10 = 0; i10 < length; ++i10) {
            long b10 = supplier.getAsByte();
            if (b10 == -1L) {
                throw new IOException("premature end of data");
            }
            l10 |= b10 << i10 * 8;
        }
        return l10;
    }

    public static long fromLittleEndian(DataInput in2, int length) throws IOException {
        ByteUtils.checkReadLength(length);
        long l10 = 0L;
        for (int i10 = 0; i10 < length; ++i10) {
            long b10 = in2.readUnsignedByte();
            l10 |= b10 << i10 * 8;
        }
        return l10;
    }

    public static void toLittleEndian(byte[] b10, long value, int off, int length) {
        long num = value;
        for (int i10 = 0; i10 < length; ++i10) {
            b10[off + i10] = (byte)(num & 0xFFL);
            num >>= 8;
        }
    }

    public static void toLittleEndian(OutputStream out, long value, int length) throws IOException {
        long num = value;
        for (int i10 = 0; i10 < length; ++i10) {
            out.write((int)(num & 0xFFL));
            num >>= 8;
        }
    }

    public static void toLittleEndian(ByteConsumer consumer, long value, int length) throws IOException {
        long num = value;
        for (int i10 = 0; i10 < length; ++i10) {
            consumer.accept((int)(num & 0xFFL));
            num >>= 8;
        }
    }

    public static void toLittleEndian(DataOutput out, long value, int length) throws IOException {
        long num = value;
        for (int i10 = 0; i10 < length; ++i10) {
            out.write((int)(num & 0xFFL));
            num >>= 8;
        }
    }

    private static final void checkReadLength(int length) {
        if (length > 8) {
            throw new IllegalArgumentException("can't read more than eight bytes into a long value");
        }
    }

    public static interface ByteConsumer {
        public void accept(int var1) throws IOException;
    }

    public static interface ByteSupplier {
        public int getAsByte() throws IOException;
    }

    public static class InputStreamByteSupplier
    implements ByteSupplier {
        private final InputStream is;

        public InputStreamByteSupplier(InputStream is2) {
            this.is = is2;
        }

        @Override
        public int getAsByte() throws IOException {
            return this.is.read();
        }
    }

    public static class OutputStreamByteConsumer
    implements ByteConsumer {
        private final OutputStream os;

        public OutputStreamByteConsumer(OutputStream os2) {
            this.os = os2;
        }

        @Override
        public void accept(int b10) throws IOException {
            this.os.write(b10);
        }
    }
}

