/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Checksum;

public class ChecksumCalculatingInputStream
extends InputStream {
    private final InputStream in;
    private final Checksum checksum;

    public ChecksumCalculatingInputStream(Checksum checksum, InputStream in2) {
        this.checksum = checksum;
        this.in = in2;
    }

    @Override
    public int read() throws IOException {
        int ret = this.in.read();
        if (ret >= 0) {
            this.checksum.update(ret);
        }
        return ret;
    }

    @Override
    public int read(byte[] b10) throws IOException {
        return this.read(b10, 0, b10.length);
    }

    @Override
    public int read(byte[] b10, int off, int len) throws IOException {
        int ret = this.in.read(b10, off, len);
        if (ret >= 0) {
            this.checksum.update(b10, off, ret);
        }
        return ret;
    }

    @Override
    public long skip(long n10) throws IOException {
        if (this.read() >= 0) {
            return 1L;
        }
        return 0L;
    }

    public long getValue() {
        return this.checksum.getValue();
    }
}

