/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends FilterInputStream {
    private long bytesRead;

    public CountingInputStream(InputStream in2) {
        super(in2);
    }

    @Override
    public int read() throws IOException {
        int r10 = this.in.read();
        if (r10 >= 0) {
            this.count(1L);
        }
        return r10;
    }

    @Override
    public int read(byte[] b10) throws IOException {
        return this.read(b10, 0, b10.length);
    }

    @Override
    public int read(byte[] b10, int off, int len) throws IOException {
        int r10 = this.in.read(b10, off, len);
        if (r10 >= 0) {
            this.count(r10);
        }
        return r10;
    }

    protected final void count(long read) {
        if (read != -1L) {
            this.bytesRead += read;
        }
    }

    public long getBytesRead() {
        return this.bytesRead;
    }
}

