/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CountingOutputStream
extends FilterOutputStream {
    private long bytesWritten = 0L;

    public CountingOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(int b10) throws IOException {
        this.out.write(b10);
        this.count(1L);
    }

    @Override
    public void write(byte[] b10) throws IOException {
        this.write(b10, 0, b10.length);
    }

    @Override
    public void write(byte[] b10, int off, int len) throws IOException {
        this.out.write(b10, off, len);
        this.count(len);
    }

    protected void count(long written) {
        if (written != -1L) {
            this.bytesWritten += written;
        }
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }
}

