/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ProxyOutputStream;

public class TeeOutputStream
extends ProxyOutputStream {
    protected OutputStream branch;

    public TeeOutputStream(OutputStream out, OutputStream branch) {
        super(out);
        this.branch = branch;
    }

    @Override
    public synchronized void write(byte[] b10) throws IOException {
        super.write(b10);
        this.branch.write(b10);
    }

    @Override
    public synchronized void write(byte[] b10, int off, int len) throws IOException {
        super.write(b10, off, len);
        this.branch.write(b10, off, len);
    }

    @Override
    public synchronized void write(int b10) throws IOException {
        super.write(b10);
        this.branch.write(b10);
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        this.branch.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.branch.close();
        }
    }
}

