/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

class IntHashMap {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public IntHashMap() {
        this(20, 0.75f);
    }

    public IntHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Entry[] tab = this.table;
        int i10 = tab.length;
        while (i10-- > 0) {
            Entry e10 = tab[i10];
            while (e10 != null) {
                if (e10.value.equals(value)) {
                    return true;
                }
                e10 = e10.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object value) {
        return this.contains(value);
    }

    public boolean containsKey(int key) {
        Entry[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e10 = tab[index];
        while (e10 != null) {
            if (e10.hash == hash) {
                return true;
            }
            e10 = e10.next;
        }
        return false;
    }

    public Object get(int key) {
        Entry[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e10 = tab[index];
        while (e10 != null) {
            if (e10.hash == hash) {
                return e10.value;
            }
            e10 = e10.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i10 = oldCapacity;
        while (i10-- > 0) {
            Entry old = oldMap[i10];
            while (old != null) {
                Entry e10 = old;
                old = old.next;
                int index = (e10.hash & Integer.MAX_VALUE) % newCapacity;
                e10.next = newMap[index];
                newMap[index] = e10;
            }
        }
    }

    public Object put(int key, Object value) {
        Entry e10;
        Entry[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e11 = tab[index];
        while (e11 != null) {
            if (e11.hash == hash) {
                Object old = e11.value;
                e11.value = value;
                return old;
            }
            e11 = e11.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e10 = new Entry(hash, key, value, tab[index]);
        ++this.count;
        return null;
    }

    public Object remove(int key) {
        Entry[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e10 = tab[index];
        Entry prev = null;
        while (e10 != null) {
            if (e10.hash == hash) {
                if (prev != null) {
                    prev.next = e10.next;
                } else {
                    tab[index] = e10.next;
                }
                --this.count;
                Object oldValue = e10.value;
                e10.value = null;
                return oldValue;
            }
            prev = e10;
            e10 = e10.next;
        }
        return null;
    }

    public synchronized void clear() {
        Entry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    private static class Entry {
        int hash;
        int key;
        Object value;
        Entry next;

        protected Entry(int hash, int key, Object value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

