/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.exception.Nestable;

public class NestableDelegate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient String MUST_BE_THROWABLE = "The Nestable implementation passed to the NestableDelegate(Nestable) constructor must extend java.lang.Throwable";
    private Throwable nestable = null;
    public static boolean topDown = true;
    public static boolean trimStackFrames = true;
    public static boolean matchSubclasses = true;
    static /* synthetic */ Class class$org$apache$commons$lang$exception$Nestable;

    public NestableDelegate(Nestable nestable) {
        if (!(nestable instanceof Throwable)) {
            throw new IllegalArgumentException(MUST_BE_THROWABLE);
        }
        this.nestable = (Throwable)((Object)nestable);
    }

    public String getMessage(int index) {
        Throwable t10;
        if ((class$org$apache$commons$lang$exception$Nestable == null ? (class$org$apache$commons$lang$exception$Nestable = NestableDelegate.class$("org.apache.commons.lang.exception.Nestable")) : class$org$apache$commons$lang$exception$Nestable).isInstance(t10 = this.getThrowable(index))) {
            return ((Nestable)((Object)t10)).getMessage(0);
        }
        return t10.getMessage();
    }

    public String getMessage(String baseMsg) {
        String causeMsg;
        Throwable nestedCause = ExceptionUtils.getCause(this.nestable);
        String string = causeMsg = nestedCause == null ? null : nestedCause.getMessage();
        if (nestedCause == null || causeMsg == null) {
            return baseMsg;
        }
        if (baseMsg == null) {
            return causeMsg;
        }
        return baseMsg + ": " + causeMsg;
    }

    public String[] getMessages() {
        Throwable[] throwables = this.getThrowables();
        String[] msgs = new String[throwables.length];
        int i10 = 0;
        while (i10 < throwables.length) {
            msgs[i10] = (class$org$apache$commons$lang$exception$Nestable == null ? NestableDelegate.class$("org.apache.commons.lang.exception.Nestable") : class$org$apache$commons$lang$exception$Nestable).isInstance(throwables[i10]) ? ((Nestable)((Object)throwables[i10])).getMessage(0) : throwables[i10].getMessage();
            ++i10;
        }
        return msgs;
    }

    public Throwable getThrowable(int index) {
        if (index == 0) {
            return this.nestable;
        }
        Throwable[] throwables = this.getThrowables();
        return throwables[index];
    }

    public int getThrowableCount() {
        return ExceptionUtils.getThrowableCount(this.nestable);
    }

    public Throwable[] getThrowables() {
        return ExceptionUtils.getThrowables(this.nestable);
    }

    public int indexOfThrowable(Class type, int fromIndex) {
        if (type == null) {
            return -1;
        }
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("The start index was out of bounds: " + fromIndex);
        }
        Throwable[] throwables = ExceptionUtils.getThrowables(this.nestable);
        if (fromIndex >= throwables.length) {
            throw new IndexOutOfBoundsException("The start index was out of bounds: " + fromIndex + " >= " + throwables.length);
        }
        if (matchSubclasses) {
            int i10 = fromIndex;
            while (i10 < throwables.length) {
                if (type.isAssignableFrom(throwables[i10].getClass())) {
                    return i10;
                }
                ++i10;
            }
        } else {
            int i11 = fromIndex;
            while (i11 < throwables.length) {
                if (type.equals(throwables[i11].getClass())) {
                    return i11;
                }
                ++i11;
            }
        }
        return -1;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream out) {
        PrintStream printStream = out;
        synchronized (printStream) {
            PrintWriter pw2 = new PrintWriter(out, false);
            this.printStackTrace(pw2);
            pw2.flush();
        }
    }

    public void printStackTrace(PrintWriter out) {
        Throwable throwable = this.nestable;
        if (ExceptionUtils.isThrowableNested()) {
            if (throwable instanceof Nestable) {
                ((Nestable)((Object)throwable)).printPartialStackTrace(out);
            } else {
                throwable.printStackTrace(out);
            }
            return;
        }
        ArrayList<String[]> stacks = new ArrayList<String[]>();
        while (throwable != null) {
            String[] st2 = this.getStackFrames(throwable);
            stacks.add(st2);
            throwable = ExceptionUtils.getCause(throwable);
        }
        String separatorLine = "Caused by: ";
        if (!topDown) {
            separatorLine = "Rethrown as: ";
            Collections.reverse(stacks);
        }
        if (trimStackFrames) {
            this.trimStackFrames(stacks);
        }
        PrintWriter printWriter = out;
        synchronized (printWriter) {
            Iterator iter = stacks.iterator();
            while (iter.hasNext()) {
                String[] st3 = (String[])iter.next();
                int i10 = 0;
                int len = st3.length;
                while (i10 < len) {
                    out.println(st3[i10]);
                    ++i10;
                }
                if (!iter.hasNext()) continue;
                out.print(separatorLine);
            }
        }
    }

    protected String[] getStackFrames(Throwable t10) {
        StringWriter sw2 = new StringWriter();
        PrintWriter pw2 = new PrintWriter((Writer)sw2, true);
        if (t10 instanceof Nestable) {
            ((Nestable)((Object)t10)).printPartialStackTrace(pw2);
        } else {
            t10.printStackTrace(pw2);
        }
        return ExceptionUtils.getStackFrames(sw2.getBuffer().toString());
    }

    protected void trimStackFrames(List stacks) {
        int size = stacks.size();
        int i10 = size - 1;
        while (i10 > 0) {
            String[] curr = (String[])stacks.get(i10);
            String[] next = (String[])stacks.get(i10 - 1);
            ArrayList<String> currList = new ArrayList<String>(Arrays.asList(curr));
            ArrayList<String> nextList = new ArrayList<String>(Arrays.asList(next));
            ExceptionUtils.removeCommonFrames(currList, nextList);
            int trimmed = curr.length - currList.size();
            if (trimmed > 0) {
                currList.add("\t... " + trimmed + " more");
                stacks.set(i10, currList.toArray(new String[currList.size()]));
            }
            --i10;
        }
    }

    static /* synthetic */ Class class$(String x02) {
        try {
            return Class.forName(x02);
        }
        catch (ClassNotFoundException x12) {
            throw new NoClassDefFoundError(x12.getMessage());
        }
    }
}

