/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.math;

import java.io.Serializable;
import java.math.BigInteger;

public final class Fraction
extends Number
implements Serializable,
Comparable {
    private static final long serialVersionUID = 65382027393090L;
    public static final Fraction ZERO = new Fraction(0, 1);
    public static final Fraction ONE = new Fraction(1, 1);
    public static final Fraction ONE_HALF = new Fraction(1, 2);
    public static final Fraction ONE_THIRD = new Fraction(1, 3);
    public static final Fraction TWO_THIRDS = new Fraction(2, 3);
    public static final Fraction ONE_QUARTER = new Fraction(1, 4);
    public static final Fraction TWO_QUARTERS = new Fraction(2, 4);
    public static final Fraction THREE_QUARTERS = new Fraction(3, 4);
    public static final Fraction ONE_FIFTH = new Fraction(1, 5);
    public static final Fraction TWO_FIFTHS = new Fraction(2, 5);
    public static final Fraction THREE_FIFTHS = new Fraction(3, 5);
    public static final Fraction FOUR_FIFTHS = new Fraction(4, 5);
    private final int numerator;
    private final int denominator;
    private transient int hashCode = 0;
    private transient String toString = null;
    private transient String toProperString = null;

    private Fraction(int numerator, int denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public static Fraction getFraction(int numerator, int denominator) {
        if (denominator == 0) {
            throw new ArithmeticException("The denominator must not be zero");
        }
        if (denominator < 0) {
            if (numerator == Integer.MIN_VALUE || denominator == Integer.MIN_VALUE) {
                throw new ArithmeticException("overflow: can't negate");
            }
            numerator = -numerator;
            denominator = -denominator;
        }
        return new Fraction(numerator, denominator);
    }

    public static Fraction getFraction(int whole, int numerator, int denominator) {
        if (denominator == 0) {
            throw new ArithmeticException("The denominator must not be zero");
        }
        if (denominator < 0) {
            throw new ArithmeticException("The denominator must not be negative");
        }
        if (numerator < 0) {
            throw new ArithmeticException("The numerator must not be negative");
        }
        long numeratorValue = whole < 0 ? (long)whole * (long)denominator - (long)numerator : (long)whole * (long)denominator + (long)numerator;
        if (numeratorValue < Integer.MIN_VALUE || numeratorValue > Integer.MAX_VALUE) {
            throw new ArithmeticException("Numerator too large to represent as an Integer.");
        }
        return new Fraction((int)numeratorValue, denominator);
    }

    public static Fraction getReducedFraction(int numerator, int denominator) {
        if (denominator == 0) {
            throw new ArithmeticException("The denominator must not be zero");
        }
        if (numerator == 0) {
            return ZERO;
        }
        if (denominator == Integer.MIN_VALUE && (numerator & 1) == 0) {
            numerator /= 2;
            denominator /= 2;
        }
        if (denominator < 0) {
            if (numerator == Integer.MIN_VALUE || denominator == Integer.MIN_VALUE) {
                throw new ArithmeticException("overflow: can't negate");
            }
            numerator = -numerator;
            denominator = -denominator;
        }
        int gcd = Fraction.greatestCommonDivisor(numerator, denominator);
        return new Fraction(numerator /= gcd, denominator /= gcd);
    }

    public static Fraction getFraction(double value) {
        double delta1;
        int sign = value < 0.0 ? -1 : 1;
        if ((value = Math.abs(value)) > 2.147483647E9 || Double.isNaN(value)) {
            throw new ArithmeticException("The value must not be greater than Integer.MAX_VALUE or NaN");
        }
        int wholeNumber = (int)value;
        value -= (double)wholeNumber;
        int numer0 = 0;
        int denom0 = 1;
        int numer1 = 1;
        int denom1 = 0;
        int numer2 = 0;
        int denom2 = 0;
        int a12 = (int)value;
        int a22 = 0;
        double x12 = 1.0;
        double x22 = 0.0;
        double y12 = value - (double)a12;
        double y22 = 0.0;
        double delta2 = Double.MAX_VALUE;
        int i10 = 1;
        do {
            delta1 = delta2;
            a22 = (int)(x12 / y12);
            x22 = y12;
            y22 = x12 - (double)a22 * y12;
            numer2 = a12 * numer1 + numer0;
            denom2 = a12 * denom1 + denom0;
            double fraction = (double)numer2 / (double)denom2;
            delta2 = Math.abs(value - fraction);
            a12 = a22;
            x12 = x22;
            y12 = y22;
            numer0 = numer1;
            denom0 = denom1;
            numer1 = numer2;
            denom1 = denom2;
        } while (delta1 > delta2 && denom2 <= 10000 && denom2 > 0 && ++i10 < 25);
        if (i10 == 25) {
            throw new ArithmeticException("Unable to convert double to fraction");
        }
        return Fraction.getReducedFraction((numer0 + wholeNumber * denom0) * sign, denom0);
    }

    public static Fraction getFraction(String str) {
        if (str == null) {
            throw new IllegalArgumentException("The string must not be null");
        }
        int pos = str.indexOf(46);
        if (pos >= 0) {
            return Fraction.getFraction(Double.parseDouble(str));
        }
        pos = str.indexOf(32);
        if (pos > 0) {
            int whole = Integer.parseInt(str.substring(0, pos));
            if ((pos = (str = str.substring(pos + 1)).indexOf(47)) < 0) {
                throw new NumberFormatException("The fraction could not be parsed as the format X Y/Z");
            }
            int numer = Integer.parseInt(str.substring(0, pos));
            int denom = Integer.parseInt(str.substring(pos + 1));
            return Fraction.getFraction(whole, numer, denom);
        }
        pos = str.indexOf(47);
        if (pos < 0) {
            return Fraction.getFraction(Integer.parseInt(str), 1);
        }
        int numer = Integer.parseInt(str.substring(0, pos));
        int denom = Integer.parseInt(str.substring(pos + 1));
        return Fraction.getFraction(numer, denom);
    }

    public int getNumerator() {
        return this.numerator;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public int getProperNumerator() {
        return Math.abs(this.numerator % this.denominator);
    }

    public int getProperWhole() {
        return this.numerator / this.denominator;
    }

    public int intValue() {
        return this.numerator / this.denominator;
    }

    public long longValue() {
        return (long)this.numerator / (long)this.denominator;
    }

    public float floatValue() {
        return (float)this.numerator / (float)this.denominator;
    }

    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    public Fraction reduce() {
        int gcd = Fraction.greatestCommonDivisor(Math.abs(this.numerator), this.denominator);
        if (gcd == 1) {
            return this;
        }
        return Fraction.getFraction(this.numerator / gcd, this.denominator / gcd);
    }

    public Fraction invert() {
        if (this.numerator == 0) {
            throw new ArithmeticException("Unable to invert zero.");
        }
        if (this.numerator == Integer.MIN_VALUE) {
            throw new ArithmeticException("overflow: can't negate numerator");
        }
        if (this.numerator < 0) {
            return new Fraction(-this.denominator, -this.numerator);
        }
        return new Fraction(this.denominator, this.numerator);
    }

    public Fraction negate() {
        if (this.numerator == Integer.MIN_VALUE) {
            throw new ArithmeticException("overflow: too large to negate");
        }
        return new Fraction(-this.numerator, this.denominator);
    }

    public Fraction abs() {
        if (this.numerator >= 0) {
            return this;
        }
        return this.negate();
    }

    public Fraction pow(int power) {
        if (power == 1) {
            return this;
        }
        if (power == 0) {
            return ONE;
        }
        if (power < 0) {
            if (power == Integer.MIN_VALUE) {
                return this.invert().pow(2).pow(-(power / 2));
            }
            return this.invert().pow(-power);
        }
        Fraction f10 = this.multiplyBy(this);
        if (power % 2 == 0) {
            return f10.pow(power / 2);
        }
        return f10.pow(power / 2).multiplyBy(this);
    }

    private static int greatestCommonDivisor(int u10, int v10) {
        if (u10 > 0) {
            u10 = -u10;
        }
        if (v10 > 0) {
            v10 = -v10;
        }
        int k10 = 0;
        while ((u10 & 1) == 0 && (v10 & 1) == 0 && k10 < 31) {
            u10 /= 2;
            v10 /= 2;
            ++k10;
        }
        if (k10 == 31) {
            throw new ArithmeticException("overflow: gcd is 2^31");
        }
        int t10 = (u10 & 1) == 1 ? v10 : -(u10 / 2);
        while (true) {
            if ((t10 & 1) == 0) {
                t10 /= 2;
                continue;
            }
            if (t10 > 0) {
                u10 = -t10;
            } else {
                v10 = t10;
            }
            if ((t10 = (v10 - u10) / 2) == 0) break;
        }
        return -u10 * (1 << k10);
    }

    private static int mulAndCheck(int x10, int y10) {
        long m10 = (long)x10 * (long)y10;
        if (m10 < Integer.MIN_VALUE || m10 > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: mul");
        }
        return (int)m10;
    }

    private static int mulPosAndCheck(int x10, int y10) {
        long m10 = (long)x10 * (long)y10;
        if (m10 > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: mulPos");
        }
        return (int)m10;
    }

    private static int addAndCheck(int x10, int y10) {
        long s10 = (long)x10 + (long)y10;
        if (s10 < Integer.MIN_VALUE || s10 > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: add");
        }
        return (int)s10;
    }

    private static int subAndCheck(int x10, int y10) {
        long s10 = (long)x10 - (long)y10;
        if (s10 < Integer.MIN_VALUE || s10 > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: add");
        }
        return (int)s10;
    }

    public Fraction add(Fraction fraction) {
        return this.addSub(fraction, true);
    }

    public Fraction subtract(Fraction fraction) {
        return this.addSub(fraction, false);
    }

    private Fraction addSub(Fraction fraction, boolean isAdd) {
        int tmodd1;
        int d22;
        if (fraction == null) {
            throw new IllegalArgumentException("The fraction must not be null");
        }
        if (this.numerator == 0) {
            return isAdd ? fraction : fraction.negate();
        }
        if (fraction.numerator == 0) {
            return this;
        }
        int d12 = Fraction.greatestCommonDivisor(this.denominator, fraction.denominator);
        if (d12 == 1) {
            int uvp = Fraction.mulAndCheck(this.numerator, fraction.denominator);
            int upv = Fraction.mulAndCheck(fraction.numerator, this.denominator);
            return new Fraction(isAdd ? Fraction.addAndCheck(uvp, upv) : Fraction.subAndCheck(uvp, upv), Fraction.mulPosAndCheck(this.denominator, fraction.denominator));
        }
        BigInteger uvp = BigInteger.valueOf(this.numerator).multiply(BigInteger.valueOf(fraction.denominator / d12));
        BigInteger upv = BigInteger.valueOf(fraction.numerator).multiply(BigInteger.valueOf(this.denominator / d12));
        BigInteger t10 = isAdd ? uvp.add(upv) : uvp.subtract(upv);
        BigInteger w10 = t10.divide(BigInteger.valueOf(d22 = (tmodd1 = t10.mod(BigInteger.valueOf(d12)).intValue()) == 0 ? d12 : Fraction.greatestCommonDivisor(tmodd1, d12)));
        if (w10.bitLength() > 31) {
            throw new ArithmeticException("overflow: numerator too large after multiply");
        }
        return new Fraction(w10.intValue(), Fraction.mulPosAndCheck(this.denominator / d12, fraction.denominator / d22));
    }

    public Fraction multiplyBy(Fraction fraction) {
        if (fraction == null) {
            throw new IllegalArgumentException("The fraction must not be null");
        }
        if (this.numerator == 0 || fraction.numerator == 0) {
            return ZERO;
        }
        int d12 = Fraction.greatestCommonDivisor(this.numerator, fraction.denominator);
        int d22 = Fraction.greatestCommonDivisor(fraction.numerator, this.denominator);
        return Fraction.getReducedFraction(Fraction.mulAndCheck(this.numerator / d12, fraction.numerator / d22), Fraction.mulPosAndCheck(this.denominator / d22, fraction.denominator / d12));
    }

    public Fraction divideBy(Fraction fraction) {
        if (fraction == null) {
            throw new IllegalArgumentException("The fraction must not be null");
        }
        if (fraction.numerator == 0) {
            throw new ArithmeticException("The fraction to divide by must not be zero");
        }
        return this.multiplyBy(fraction.invert());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Fraction)) {
            return false;
        }
        Fraction other = (Fraction)obj;
        return this.getNumerator() == other.getNumerator() && this.getDenominator() == other.getDenominator();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 37 * (629 + this.getNumerator()) + this.getDenominator();
        }
        return this.hashCode;
    }

    public int compareTo(Object object) {
        Fraction other = (Fraction)object;
        if (this == other) {
            return 0;
        }
        if (this.numerator == other.numerator && this.denominator == other.denominator) {
            return 0;
        }
        long first = (long)this.numerator * (long)other.denominator;
        long second = (long)other.numerator * (long)this.denominator;
        if (first == second) {
            return 0;
        }
        if (first < second) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = new StringBuffer(32).append(this.getNumerator()).append('/').append(this.getDenominator()).toString();
        }
        return this.toString;
    }

    public String toProperString() {
        if (this.toProperString == null) {
            int properNumerator;
            this.toProperString = this.numerator == 0 ? "0" : (this.numerator == this.denominator ? "1" : (this.numerator == -1 * this.denominator ? "-1" : ((this.numerator > 0 ? -this.numerator : this.numerator) < -this.denominator ? ((properNumerator = this.getProperNumerator()) == 0 ? Integer.toString(this.getProperWhole()) : new StringBuffer(32).append(this.getProperWhole()).append(' ').append(properNumerator).append('/').append(this.getDenominator()).toString()) : new StringBuffer(32).append(this.getNumerator()).append('/').append(this.getDenominator()).toString())));
        }
        return this.toProperString;
    }
}

