/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.lang.StringUtils;

public class NumberUtils {
    public static final Long LONG_ZERO = new Long(0L);
    public static final Long LONG_ONE = new Long(1L);
    public static final Long LONG_MINUS_ONE = new Long(-1L);
    public static final Integer INTEGER_ZERO = new Integer(0);
    public static final Integer INTEGER_ONE = new Integer(1);
    public static final Integer INTEGER_MINUS_ONE = new Integer(-1);
    public static final Short SHORT_ZERO = new Short(0);
    public static final Short SHORT_ONE = new Short(1);
    public static final Short SHORT_MINUS_ONE = new Short(-1);
    public static final Byte BYTE_ZERO = new Byte(0);
    public static final Byte BYTE_ONE = new Byte(1);
    public static final Byte BYTE_MINUS_ONE = new Byte(-1);
    public static final Double DOUBLE_ZERO = new Double(0.0);
    public static final Double DOUBLE_ONE = new Double(1.0);
    public static final Double DOUBLE_MINUS_ONE = new Double(-1.0);
    public static final Float FLOAT_ZERO = new Float(0.0f);
    public static final Float FLOAT_ONE = new Float(1.0f);
    public static final Float FLOAT_MINUS_ONE = new Float(-1.0f);

    public static int stringToInt(String str) {
        return NumberUtils.toInt(str);
    }

    public static int toInt(String str) {
        return NumberUtils.toInt(str, 0);
    }

    public static int stringToInt(String str, int defaultValue) {
        return NumberUtils.toInt(str, defaultValue);
    }

    public static int toInt(String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static long toLong(String str) {
        return NumberUtils.toLong(str, 0L);
    }

    public static long toLong(String str, long defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static float toFloat(String str) {
        return NumberUtils.toFloat(str, 0.0f);
    }

    public static float toFloat(String str, float defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static double toDouble(String str) {
        return NumberUtils.toDouble(str, 0.0);
    }

    public static double toDouble(String str, double defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static Number createNumber(String str) throws NumberFormatException {
        String mant;
        String dec;
        if (str == null) {
            return null;
        }
        if (StringUtils.isBlank(str)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        if (str.startsWith("--")) {
            return null;
        }
        if (str.startsWith("0x") || str.startsWith("-0x")) {
            return NumberUtils.createInteger(str);
        }
        char lastChar = str.charAt(str.length() - 1);
        int decPos = str.indexOf(46);
        int expPos = str.indexOf(101) + str.indexOf(69) + 1;
        if (decPos > -1) {
            if (expPos > -1) {
                if (expPos < decPos) {
                    throw new NumberFormatException(str + " is not a valid number.");
                }
                dec = str.substring(decPos + 1, expPos);
            } else {
                dec = str.substring(decPos + 1);
            }
            mant = str.substring(0, decPos);
        } else {
            mant = expPos > -1 ? str.substring(0, expPos) : str;
            dec = null;
        }
        if (!Character.isDigit(lastChar)) {
            String exp = expPos > -1 && expPos < str.length() - 1 ? str.substring(expPos + 1, str.length() - 1) : null;
            String numeric = str.substring(0, str.length() - 1);
            boolean allZeros = NumberUtils.isAllZeros(mant) && NumberUtils.isAllZeros(exp);
            switch (lastChar) {
                case 'L': 
                case 'l': {
                    if (dec == null && exp == null && NumberUtils.isDigits(numeric.substring(1)) && (numeric.charAt(0) == '-' || Character.isDigit(numeric.charAt(0)))) {
                        try {
                            return NumberUtils.createLong(numeric);
                        }
                        catch (NumberFormatException nfe) {
                            return NumberUtils.createBigInteger(numeric);
                        }
                    }
                    throw new NumberFormatException(str + " is not a valid number.");
                }
                case 'F': 
                case 'f': {
                    try {
                        Float f10 = NumberUtils.createFloat(numeric);
                        if (!f10.isInfinite() && (f10.floatValue() != 0.0f || allZeros)) {
                            return f10;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                case 'D': 
                case 'd': {
                    try {
                        Double d10 = NumberUtils.createDouble(numeric);
                        if (!d10.isInfinite() && ((double)d10.floatValue() != 0.0 || allZeros)) {
                            return d10;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    try {
                        return NumberUtils.createBigDecimal(numeric);
                    }
                    catch (NumberFormatException e10) {
                        // empty catch block
                    }
                }
            }
            throw new NumberFormatException(str + " is not a valid number.");
        }
        String exp = expPos > -1 && expPos < str.length() - 1 ? str.substring(expPos + 1, str.length()) : null;
        if (dec == null && exp == null) {
            try {
                return NumberUtils.createInteger(str);
            }
            catch (NumberFormatException nfe) {
                try {
                    return NumberUtils.createLong(str);
                }
                catch (NumberFormatException nfe2) {
                    return NumberUtils.createBigInteger(str);
                }
            }
        }
        boolean allZeros = NumberUtils.isAllZeros(mant) && NumberUtils.isAllZeros(exp);
        try {
            Float f11 = NumberUtils.createFloat(str);
            if (!f11.isInfinite() && (f11.floatValue() != 0.0f || allZeros)) {
                return f11;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        try {
            Double d11 = NumberUtils.createDouble(str);
            if (!d11.isInfinite() && (d11 != 0.0 || allZeros)) {
                return d11;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return NumberUtils.createBigDecimal(str);
    }

    private static boolean isAllZeros(String str) {
        if (str == null) {
            return true;
        }
        int i10 = str.length() - 1;
        while (i10 >= 0) {
            if (str.charAt(i10) != '0') {
                return false;
            }
            --i10;
        }
        return str.length() > 0;
    }

    public static Float createFloat(String str) {
        if (str == null) {
            return null;
        }
        return Float.valueOf(str);
    }

    public static Double createDouble(String str) {
        if (str == null) {
            return null;
        }
        return Double.valueOf(str);
    }

    public static Integer createInteger(String str) {
        if (str == null) {
            return null;
        }
        return Integer.decode(str);
    }

    public static Long createLong(String str) {
        if (str == null) {
            return null;
        }
        return Long.valueOf(str);
    }

    public static BigInteger createBigInteger(String str) {
        if (str == null) {
            return null;
        }
        return new BigInteger(str);
    }

    public static BigDecimal createBigDecimal(String str) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isBlank(str)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        return new BigDecimal(str);
    }

    public static long min(long[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        long min = array[0];
        int i10 = 1;
        while (i10 < array.length) {
            if (array[i10] < min) {
                min = array[i10];
            }
            ++i10;
        }
        return min;
    }

    public static int min(int[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        int min = array[0];
        int j10 = 1;
        while (j10 < array.length) {
            if (array[j10] < min) {
                min = array[j10];
            }
            ++j10;
        }
        return min;
    }

    public static short min(short[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        short min = array[0];
        int i10 = 1;
        while (i10 < array.length) {
            if (array[i10] < min) {
                min = array[i10];
            }
            ++i10;
        }
        return min;
    }

    public static double min(double[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        double min = array[0];
        int i10 = 1;
        while (i10 < array.length) {
            if (array[i10] < min) {
                min = array[i10];
            }
            ++i10;
        }
        return min;
    }

    public static float min(float[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        float min = array[0];
        int i10 = 1;
        while (i10 < array.length) {
            if (array[i10] < min) {
                min = array[i10];
            }
            ++i10;
        }
        return min;
    }

    public static long max(long[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        long max = array[0];
        int j10 = 1;
        while (j10 < array.length) {
            if (array[j10] > max) {
                max = array[j10];
            }
            ++j10;
        }
        return max;
    }

    public static int max(int[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        int max = array[0];
        int j10 = 1;
        while (j10 < array.length) {
            if (array[j10] > max) {
                max = array[j10];
            }
            ++j10;
        }
        return max;
    }

    public static short max(short[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        short max = array[0];
        int i10 = 1;
        while (i10 < array.length) {
            if (array[i10] > max) {
                max = array[i10];
            }
            ++i10;
        }
        return max;
    }

    public static double max(double[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        double max = array[0];
        int j10 = 1;
        while (j10 < array.length) {
            if (array[j10] > max) {
                max = array[j10];
            }
            ++j10;
        }
        return max;
    }

    public static float max(float[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        float max = array[0];
        int j10 = 1;
        while (j10 < array.length) {
            if (array[j10] > max) {
                max = array[j10];
            }
            ++j10;
        }
        return max;
    }

    public static long min(long a10, long b10, long c10) {
        if (b10 < a10) {
            a10 = b10;
        }
        if (c10 < a10) {
            a10 = c10;
        }
        return a10;
    }

    public static int min(int a10, int b10, int c10) {
        if (b10 < a10) {
            a10 = b10;
        }
        if (c10 < a10) {
            a10 = c10;
        }
        return a10;
    }

    public static short min(short a10, short b10, short c10) {
        if (b10 < a10) {
            a10 = b10;
        }
        if (c10 < a10) {
            a10 = c10;
        }
        return a10;
    }

    public static byte min(byte a10, byte b10, byte c10) {
        if (b10 < a10) {
            a10 = b10;
        }
        if (c10 < a10) {
            a10 = c10;
        }
        return a10;
    }

    public static double min(double a10, double b10, double c10) {
        return Math.min(Math.min(a10, b10), c10);
    }

    public static float min(float a10, float b10, float c10) {
        return Math.min(Math.min(a10, b10), c10);
    }

    public static long max(long a10, long b10, long c10) {
        if (b10 > a10) {
            a10 = b10;
        }
        if (c10 > a10) {
            a10 = c10;
        }
        return a10;
    }

    public static int max(int a10, int b10, int c10) {
        if (b10 > a10) {
            a10 = b10;
        }
        if (c10 > a10) {
            a10 = c10;
        }
        return a10;
    }

    public static short max(short a10, short b10, short c10) {
        if (b10 > a10) {
            a10 = b10;
        }
        if (c10 > a10) {
            a10 = c10;
        }
        return a10;
    }

    public static byte max(byte a10, byte b10, byte c10) {
        if (b10 > a10) {
            a10 = b10;
        }
        if (c10 > a10) {
            a10 = c10;
        }
        return a10;
    }

    public static double max(double a10, double b10, double c10) {
        return Math.max(Math.max(a10, b10), c10);
    }

    public static float max(float a10, float b10, float c10) {
        return Math.max(Math.max(a10, b10), c10);
    }

    public static int compare(double lhs, double rhs) {
        long rhsBits;
        if (lhs < rhs) {
            return -1;
        }
        if (lhs > rhs) {
            return 1;
        }
        long lhsBits = Double.doubleToLongBits(lhs);
        if (lhsBits == (rhsBits = Double.doubleToLongBits(rhs))) {
            return 0;
        }
        if (lhsBits < rhsBits) {
            return -1;
        }
        return 1;
    }

    public static int compare(float lhs, float rhs) {
        int rhsBits;
        if (lhs < rhs) {
            return -1;
        }
        if (lhs > rhs) {
            return 1;
        }
        int lhsBits = Float.floatToIntBits(lhs);
        if (lhsBits == (rhsBits = Float.floatToIntBits(rhs))) {
            return 0;
        }
        if (lhsBits < rhsBits) {
            return -1;
        }
        return 1;
    }

    public static boolean isDigits(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        int i10 = 0;
        while (i10 < str.length()) {
            if (!Character.isDigit(str.charAt(i10))) {
                return false;
            }
            ++i10;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isNumber(String str) {
        block21: {
            if (StringUtils.isEmpty(str)) {
                return false;
            }
            chars = str.toCharArray();
            sz = chars.length;
            hasExp = false;
            hasDecPoint = false;
            allowSigns = false;
            foundDigit = false;
            v0 = start = chars[0] == '-' ? 1 : 0;
            if (sz <= start + 1 || chars[start] != '0' || chars[start + 1] != 'x') break block21;
            i = start + 2;
            if (i != sz) ** GOTO lbl17
            return false;
lbl-1000:
            // 1 sources

            {
                if (!(chars[i] >= '0' && chars[i] <= '9' || chars[i] >= 'a' && chars[i] <= 'f' || chars[i] >= 'A' && chars[i] <= 'F')) {
                    return false;
                }
                ++i;
lbl17:
                // 2 sources

                ** while (i < chars.length)
            }
lbl18:
            // 1 sources

            return true;
        }
        --sz;
        i = start;
        while (i < sz || i < sz + 1 && allowSigns && !foundDigit) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                foundDigit = true;
                allowSigns = false;
            } else if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
            } else if (chars[i] == 'e' || chars[i] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
            } else if (chars[i] == '+' || chars[i] == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
            } else {
                return false;
            }
            ++i;
        }
        if (i < chars.length) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                return true;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                return false;
            }
            if (!(allowSigns || chars[i] != 'd' && chars[i] != 'D' && chars[i] != 'f' && chars[i] != 'F')) {
                return foundDigit;
            }
            if (chars[i] == 'l' || chars[i] == 'L') {
                return foundDigit != false && hasExp == false;
            }
            return false;
        }
        return allowSigns == false && foundDigit != false;
    }
}

