/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.cookie;

import java.util.Comparator;
import java.util.Date;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;

@Contract(threading=ThreadingBehavior.STATELESS)
public class CookiePriorityComparator
implements Comparator<Cookie> {
    public static final CookiePriorityComparator INSTANCE = new CookiePriorityComparator();

    private int getPathLength(Cookie cookie) {
        String path = cookie.getPath();
        return path != null ? path.length() : 1;
    }

    @Override
    public int compare(Cookie c12, Cookie c22) {
        int l12 = this.getPathLength(c12);
        int l22 = this.getPathLength(c22);
        int result = l22 - l12;
        if (result == 0) {
            Date d12 = c12.getCreationDate();
            Date d22 = c22.getCreationDate();
            if (d12 != null && d22 != null) {
                return (int)(d12.getTime() - d22.getTime());
            }
        }
        return result;
    }
}

