/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;

public class DeflateInputStream
extends InputStream {
    private final InputStream sourceStream;

    public DeflateInputStream(InputStream wrapped) throws IOException {
        PushbackInputStream pushback = new PushbackInputStream(wrapped, 2);
        int i12 = pushback.read();
        int i22 = pushback.read();
        if (i12 == -1 || i22 == -1) {
            throw new ZipException("Unexpected end of stream");
        }
        pushback.unread(i22);
        pushback.unread(i12);
        boolean nowrap = true;
        int b12 = i12 & 0xFF;
        int compressionMethod = b12 & 0xF;
        int compressionInfo = b12 >> 4 & 0xF;
        int b22 = i22 & 0xFF;
        if (compressionMethod == 8 && compressionInfo <= 7 && (b12 << 8 | b22) % 31 == 0) {
            nowrap = false;
        }
        this.sourceStream = new DeflateStream(pushback, new Inflater(nowrap));
    }

    @Override
    public int read() throws IOException {
        return this.sourceStream.read();
    }

    @Override
    public int read(byte[] b10) throws IOException {
        return this.sourceStream.read(b10);
    }

    @Override
    public int read(byte[] b10, int off, int len) throws IOException {
        return this.sourceStream.read(b10, off, len);
    }

    @Override
    public long skip(long n10) throws IOException {
        return this.sourceStream.skip(n10);
    }

    @Override
    public int available() throws IOException {
        return this.sourceStream.available();
    }

    @Override
    public void mark(int readLimit) {
        this.sourceStream.mark(readLimit);
    }

    @Override
    public void reset() throws IOException {
        this.sourceStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.sourceStream.markSupported();
    }

    @Override
    public void close() throws IOException {
        this.sourceStream.close();
    }

    static class DeflateStream
    extends InflaterInputStream {
        private boolean closed = false;

        public DeflateStream(InputStream in2, Inflater inflater) {
            super(in2, inflater);
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.inf.end();
            super.close();
        }
    }
}

