/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity.mime;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hc.client5.http.entity.mime.AbstractContentBody;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.util.Args;

public class InputStreamBody
extends AbstractContentBody {
    private final InputStream in;
    private final String filename;
    private final long contentLength;

    public InputStreamBody(InputStream in2, String filename) {
        this(in2, ContentType.DEFAULT_BINARY, filename);
    }

    public InputStreamBody(InputStream in2, ContentType contentType, String filename) {
        this(in2, contentType, filename, -1L);
    }

    public InputStreamBody(InputStream in2, ContentType contentType, String filename, long contentLength) {
        super(contentType);
        Args.notNull(in2, "Input stream");
        this.in = in2;
        this.filename = filename;
        this.contentLength = contentLength >= 0L ? contentLength : -1L;
    }

    public InputStreamBody(InputStream in2, ContentType contentType) {
        this(in2, contentType, null);
    }

    public InputStream getInputStream() {
        return this.in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream out) throws IOException {
        Args.notNull(out, "Output stream");
        try {
            int l10;
            byte[] tmp = new byte[4096];
            while ((l10 = this.in.read(tmp)) != -1) {
                out.write(tmp, 0, l10);
            }
            out.flush();
        }
        finally {
            this.in.close();
        }
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }
}

