/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import java.nio.ByteBuffer;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;

@Internal
public class Wire {
    private static final int MAX_STRING_BUILDER_SIZE = 2048;
    private static final ThreadLocal<StringBuilder> THREAD_LOCAL = new ThreadLocal();
    private final Logger log;
    private final String id;

    private static StringBuilder getStringBuilder() {
        StringBuilder result = THREAD_LOCAL.get();
        if (result == null) {
            result = new StringBuilder(2048);
            THREAD_LOCAL.set(result);
        }
        Wire.trimToMaxSize(result, 2048);
        result.setLength(0);
        return result;
    }

    private static void trimToMaxSize(StringBuilder stringBuilder, int maxSize) {
        if (stringBuilder != null && stringBuilder.capacity() > maxSize) {
            stringBuilder.setLength(maxSize);
            stringBuilder.trimToSize();
        }
    }

    public Wire(Logger log, String id2) {
        this.log = log;
        this.id = id2;
    }

    private void wire(String header, byte[] b10, int pos, int off) {
        StringBuilder buffer = Wire.getStringBuilder();
        for (int i10 = 0; i10 < off; ++i10) {
            byte ch2 = b10[pos + i10];
            if (ch2 == 13) {
                buffer.append("[\\r]");
                continue;
            }
            if (ch2 == 10) {
                buffer.append("[\\n]\"");
                buffer.insert(0, "\"");
                buffer.insert(0, header);
                this.log.debug(this.id + " " + buffer.toString());
                buffer.setLength(0);
                continue;
            }
            if (ch2 < 32 || ch2 >= 127) {
                buffer.append("[0x");
                buffer.append(Integer.toHexString(ch2));
                buffer.append("]");
                continue;
            }
            buffer.append((char)ch2);
        }
        if (buffer.length() > 0) {
            buffer.append('\"');
            buffer.insert(0, '\"');
            buffer.insert(0, header);
            this.log.debug(this.id + " " + buffer.toString());
        }
    }

    public boolean isEnabled() {
        return this.log.isDebugEnabled();
    }

    public void output(byte[] b10, int pos, int off) {
        Args.notNull(b10, "Output");
        this.wire(">> ", b10, pos, off);
    }

    public void input(byte[] b10, int pos, int off) {
        Args.notNull(b10, "Input");
        this.wire("<< ", b10, pos, off);
    }

    public void output(byte[] b10) {
        Args.notNull(b10, "Output");
        this.output(b10, 0, b10.length);
    }

    public void input(byte[] b10) {
        Args.notNull(b10, "Input");
        this.input(b10, 0, b10.length);
    }

    public void output(int b10) {
        this.output(new byte[]{(byte)b10});
    }

    public void input(int b10) {
        this.input(new byte[]{(byte)b10});
    }

    public void output(String s10) {
        Args.notNull(s10, "Output");
        this.output(s10.getBytes());
    }

    public void input(String s10) {
        Args.notNull(s10, "Input");
        this.input(s10.getBytes());
    }

    public void output(ByteBuffer b10) {
        Args.notNull(b10, "Output");
        if (b10.hasArray()) {
            this.output(b10.array(), b10.arrayOffset() + b10.position(), b10.remaining());
        } else {
            byte[] tmp = new byte[b10.remaining()];
            b10.get(tmp);
            this.output(tmp);
        }
    }

    public void input(ByteBuffer b10) {
        Args.notNull(b10, "Input");
        if (b10.hasArray()) {
            this.input(b10.array(), b10.arrayOffset() + b10.position(), b10.remaining());
        } else {
            byte[] tmp = new byte[b10.remaining()];
            b10.get(tmp);
            this.input(tmp);
        }
    }
}

