/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import org.slf4j.Logger;

final class LogAppendable
implements Appendable {
    private final Logger log;
    private final String prefix;
    private final StringBuilder buffer;

    public LogAppendable(Logger log, String prefix) {
        this.log = log;
        this.prefix = prefix;
        this.buffer = new StringBuilder();
    }

    @Override
    public Appendable append(CharSequence text) throws IOException {
        return this.append(text, 0, text.length());
    }

    @Override
    public Appendable append(CharSequence text, int start, int end) throws IOException {
        for (int i10 = start; i10 < end; ++i10) {
            this.append(text.charAt(i10));
        }
        return this;
    }

    @Override
    public Appendable append(char ch2) throws IOException {
        if (ch2 == '\n') {
            this.log.debug(this.prefix + " " + this.buffer.toString());
            this.buffer.setLength(0);
        } else if (ch2 != '\r') {
            this.buffer.append(ch2);
        }
        return this;
    }

    public void flush() {
        if (this.buffer.length() > 0) {
            this.log.debug(this.prefix + " " + this.buffer.toString());
            this.buffer.setLength(0);
        }
    }
}

