/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.util.concurrent.locks.Lock;
import org.apache.hc.client5.http.impl.Wire;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;

class LoggingIOSession
implements IOSession {
    private final Logger log;
    private final Wire wireLog;
    private final String id;
    private final IOSession session;

    public LoggingIOSession(IOSession session, Logger log, Logger wireLog) {
        this.session = session;
        this.id = session.getId();
        this.log = log;
        this.wireLog = new Wire(wireLog, this.id);
    }

    @Override
    public String getId() {
        return this.session.getId();
    }

    @Override
    public Lock getLock() {
        return this.session.getLock();
    }

    @Override
    public boolean hasCommands() {
        return this.session.hasCommands();
    }

    @Override
    public Command poll() {
        return this.session.poll();
    }

    @Override
    public void enqueue(Command command, Command.Priority priority) {
        this.session.enqueue(command, priority);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.session + " Enqueued " + command.getClass().getSimpleName() + " with priority " + (Object)((Object)priority));
        }
    }

    @Override
    public ByteChannel channel() {
        return this.session.channel();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.session.getLocalAddress();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.session.getRemoteAddress();
    }

    @Override
    public int getEventMask() {
        return this.session.getEventMask();
    }

    private static String formatOps(int ops) {
        StringBuilder buffer = new StringBuilder(6);
        buffer.append('[');
        if ((ops & 1) > 0) {
            buffer.append('r');
        }
        if ((ops & 4) > 0) {
            buffer.append('w');
        }
        if ((ops & 0x10) > 0) {
            buffer.append('a');
        }
        if ((ops & 8) > 0) {
            buffer.append('c');
        }
        buffer.append(']');
        return buffer.toString();
    }

    @Override
    public void setEventMask(int ops) {
        this.session.setEventMask(ops);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.id + " " + this.session + ": Event mask set " + LoggingIOSession.formatOps(ops));
        }
    }

    @Override
    public void setEvent(int op2) {
        this.session.setEvent(op2);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.id + " " + this.session + ": Event set " + LoggingIOSession.formatOps(op2));
        }
    }

    @Override
    public void clearEvent(int op2) {
        this.session.clearEvent(op2);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.id + " " + this.session + ": Event cleared " + LoggingIOSession.formatOps(op2));
        }
    }

    @Override
    public boolean isOpen() {
        return this.session.isOpen();
    }

    @Override
    public void close() {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.id + " " + this.session + ": Close");
        }
        this.session.close();
    }

    @Override
    public IOSession.Status getStatus() {
        return this.session.getStatus();
    }

    @Override
    public void close(CloseMode closeMode) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.id + " " + this.session + ": Close " + (Object)((Object)closeMode));
        }
        this.session.close(closeMode);
    }

    @Override
    public Timeout getSocketTimeout() {
        return this.session.getSocketTimeout();
    }

    @Override
    public void setSocketTimeout(Timeout timeout) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.id + " " + this.session + ": Set timeout " + timeout);
        }
        this.session.setSocketTimeout(timeout);
    }

    @Override
    public long getLastReadTime() {
        return this.session.getLastReadTime();
    }

    @Override
    public long getLastWriteTime() {
        return this.session.getLastWriteTime();
    }

    @Override
    public void updateReadTime() {
        this.session.updateReadTime();
    }

    @Override
    public void updateWriteTime() {
        this.session.updateWriteTime();
    }

    @Override
    public long getLastEventTime() {
        return this.session.getLastEventTime();
    }

    @Override
    public IOEventHandler getHandler() {
        return this.session.getHandler();
    }

    @Override
    public void upgrade(IOEventHandler handler) {
        this.session.upgrade(handler);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int bytesRead = this.session.channel().read(dst);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.id + " " + this.session + ": " + bytesRead + " bytes read");
        }
        if (bytesRead > 0 && this.wireLog.isEnabled()) {
            ByteBuffer b10 = dst.duplicate();
            int p10 = b10.position();
            b10.limit(p10);
            b10.position(p10 - bytesRead);
            this.wireLog.input(b10);
        }
        return bytesRead;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int byteWritten = this.session.channel().write(src);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.id + " " + this.session + ": " + byteWritten + " bytes written");
        }
        if (byteWritten > 0 && this.wireLog.isEnabled()) {
            ByteBuffer b10 = src.duplicate();
            int p10 = b10.position();
            b10.limit(p10);
            b10.position(p10 - byteWritten);
            this.wireLog.output(b10);
        }
        return byteWritten;
    }

    public String toString() {
        return this.id + " " + this.session.toString();
    }
}

