/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import org.apache.hc.client5.http.impl.async.LoggingIOSession;
import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.reactor.IOSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LoggingIOSessionDecorator
implements Decorator<IOSession> {
    public static final LoggingIOSessionDecorator INSTANCE = new LoggingIOSessionDecorator();
    private final Logger wireLog = LoggerFactory.getLogger("org.apache.hc.client5.http.wire");

    private LoggingIOSessionDecorator() {
    }

    @Override
    public IOSession decorate(IOSession ioSession) {
        Logger sessionLog = LoggerFactory.getLogger(ioSession.getClass());
        if (sessionLog.isDebugEnabled() || this.wireLog.isDebugEnabled()) {
            return new LoggingIOSession(ioSession, sessionLog, this.wireLog);
        }
        return ioSession;
    }
}

