/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.net.URI;
import org.apache.hc.client5.http.CircularRedirectException;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.RedirectException;
import org.apache.hc.client5.http.auth.AuthExchange;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.RequestEntityProxy;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.RedirectLocations;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.utils.URIUtils;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.LangUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public final class RedirectExec
implements ExecChainHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final RedirectStrategy redirectStrategy;
    private final HttpRoutePlanner routePlanner;

    public RedirectExec(HttpRoutePlanner routePlanner, RedirectStrategy redirectStrategy) {
        Args.notNull(routePlanner, "HTTP route planner");
        Args.notNull(redirectStrategy, "HTTP redirect strategy");
        this.routePlanner = routePlanner;
        this.redirectStrategy = redirectStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        Args.notNull(request, "HTTP request");
        Args.notNull(scope, "Scope");
        HttpClientContext context = scope.clientContext;
        RedirectLocations redirectLocations = context.getRedirectLocations();
        if (redirectLocations == null) {
            redirectLocations = new RedirectLocations();
            context.setAttribute("http.protocol.redirect-locations", redirectLocations);
        }
        redirectLocations.clear();
        RequestConfig config = context.getRequestConfig();
        int maxRedirects = config.getMaxRedirects() > 0 ? config.getMaxRedirects() : 50;
        HttpMessage currentRequest = request;
        ExecChain.Scope currentScope = scope;
        int redirectCount = 0;
        while (true) {
            String exchangeId = currentScope.exchangeId;
            ClassicHttpResponse response = chain.proceed((ClassicHttpRequest)currentRequest, currentScope);
            try {
                HttpRoute newRoute;
                if (!config.isRedirectsEnabled()) return response;
                if (!this.redirectStrategy.isRedirected(request, response, context)) return response;
                HttpEntity requestEntity = request.getEntity();
                if (requestEntity != null && !requestEntity.isRepeatable()) {
                    if (!this.log.isDebugEnabled()) return response;
                    this.log.debug(exchangeId + ": cannot redirect non-repeatable request");
                    return response;
                }
                if (redirectCount >= maxRedirects) {
                    throw new RedirectException("Maximum redirects (" + maxRedirects + ") exceeded");
                }
                ++redirectCount;
                URI redirectUri = this.redirectStrategy.getLocationURI((HttpRequest)currentRequest, response, context);
                if (this.log.isDebugEnabled()) {
                    this.log.debug(exchangeId + ": redirect requested to location '" + redirectUri + "'");
                }
                if (!config.isCircularRedirectsAllowed() && redirectLocations.contains(redirectUri)) {
                    throw new CircularRedirectException("Circular redirect to '" + redirectUri + "'");
                }
                redirectLocations.add(redirectUri);
                ClassicHttpRequest originalRequest = scope.originalRequest;
                HttpMessage redirect = null;
                int statusCode = response.getCode();
                switch (statusCode) {
                    case 301: 
                    case 302: 
                    case 303: {
                        if (!Method.POST.isSame(request.getMethod())) break;
                        redirect = new HttpGet(redirectUri);
                        break;
                    }
                }
                if (redirect == null) {
                    redirect = new BasicClassicHttpRequest(originalRequest.getMethod(), redirectUri);
                    redirect.setEntity(originalRequest.getEntity());
                }
                redirect.setHeaders(originalRequest.getHeaders());
                HttpHost newTarget = URIUtils.extractHost(redirectUri);
                if (newTarget == null) {
                    throw new ProtocolException("Redirect URI does not specify a valid host name: " + redirectUri);
                }
                HttpRoute currentRoute = currentScope.route;
                if (!LangUtils.equals(currentRoute.getTargetHost(), newTarget) && !LangUtils.equals(currentRoute, newRoute = this.routePlanner.determineRoute(newTarget, context))) {
                    AuthExchange proxyAuthExchange;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(exchangeId + ": new route required");
                    }
                    AuthExchange targetAuthExchange = context.getAuthExchange(currentRoute.getTargetHost());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(exchangeId + ": resetting target auth state");
                    }
                    targetAuthExchange.reset();
                    if (currentRoute.getProxyHost() != null && (proxyAuthExchange = context.getAuthExchange(currentRoute.getProxyHost())).isConnectionBased()) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug(exchangeId + ": resetting proxy auth state");
                        }
                        proxyAuthExchange.reset();
                    }
                    currentScope = new ExecChain.Scope(currentScope.exchangeId, newRoute, currentScope.originalRequest, currentScope.execRuntime, currentScope.clientContext);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug(exchangeId + ": redirecting to '" + redirectUri + "' via " + currentRoute);
                }
                currentRequest = redirect;
                RequestEntityProxy.enhance(currentRequest);
                EntityUtils.consume(response.getEntity());
                response.close();
            }
            catch (IOException | RuntimeException ex2) {
                response.close();
                throw ex2;
            }
            catch (HttpException ex3) {
                try {
                    EntityUtils.consume(response.getEntity());
                    throw ex3;
                }
                catch (IOException ioex) {
                    if (!this.log.isDebugEnabled()) throw ex3;
                    this.log.debug(exchangeId + ": I/O error while releasing connection", ioex);
                    throw ex3;
                }
                finally {
                    response.close();
                }
            }
        }
    }
}

