/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hc.client5.http.impl.Wire;

class LoggingInputStream
extends InputStream {
    private final InputStream in;
    private final Wire wire;

    public LoggingInputStream(InputStream in2, Wire wire) {
        this.in = in2;
        this.wire = wire;
    }

    @Override
    public int read() throws IOException {
        try {
            int b10 = this.in.read();
            if (b10 == -1) {
                this.wire.input("end of stream");
            } else {
                this.wire.input(b10);
            }
            return b10;
        }
        catch (IOException ex2) {
            this.wire.input("[read] I/O error: " + ex2.getMessage());
            throw ex2;
        }
    }

    @Override
    public int read(byte[] b10) throws IOException {
        try {
            int bytesRead = this.in.read(b10);
            if (bytesRead == -1) {
                this.wire.input("end of stream");
            } else if (bytesRead > 0) {
                this.wire.input(b10, 0, bytesRead);
            }
            return bytesRead;
        }
        catch (IOException ex2) {
            this.wire.input("[read] I/O error: " + ex2.getMessage());
            throw ex2;
        }
    }

    @Override
    public int read(byte[] b10, int off, int len) throws IOException {
        try {
            int bytesRead = this.in.read(b10, off, len);
            if (bytesRead == -1) {
                this.wire.input("end of stream");
            } else if (bytesRead > 0) {
                this.wire.input(b10, off, bytesRead);
            }
            return bytesRead;
        }
        catch (IOException ex2) {
            this.wire.input("[read] I/O error: " + ex2.getMessage());
            throw ex2;
        }
    }

    @Override
    public long skip(long n10) throws IOException {
        try {
            return super.skip(n10);
        }
        catch (IOException ex2) {
            this.wire.input("[skip] I/O error: " + ex2.getMessage());
            throw ex2;
        }
    }

    @Override
    public int available() throws IOException {
        try {
            return this.in.available();
        }
        catch (IOException ex2) {
            this.wire.input("[available] I/O error : " + ex2.getMessage());
            throw ex2;
        }
    }

    @Override
    public void mark(int readlimit) {
        super.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        super.reset();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        catch (IOException ex2) {
            this.wire.input("[close] I/O error: " + ex2.getMessage());
            throw ex2;
        }
    }
}

