/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hc.client5.http.impl.Wire;

class LoggingOutputStream
extends OutputStream {
    private final OutputStream out;
    private final Wire wire;

    public LoggingOutputStream(OutputStream out, Wire wire) {
        this.out = out;
        this.wire = wire;
    }

    @Override
    public void write(int b10) throws IOException {
        try {
            this.out.write(b10);
            this.wire.output(b10);
        }
        catch (IOException ex2) {
            this.wire.output("[write] I/O error: " + ex2.getMessage());
            throw ex2;
        }
    }

    @Override
    public void write(byte[] b10) throws IOException {
        try {
            this.wire.output(b10);
            this.out.write(b10);
        }
        catch (IOException ex2) {
            this.wire.output("[write] I/O error: " + ex2.getMessage());
            throw ex2;
        }
    }

    @Override
    public void write(byte[] b10, int off, int len) throws IOException {
        try {
            this.wire.output(b10, off, len);
            this.out.write(b10, off, len);
        }
        catch (IOException ex2) {
            this.wire.output("[write] I/O error: " + ex2.getMessage());
            throw ex2;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.out.flush();
        }
        catch (IOException ex2) {
            this.wire.output("[flush] I/O error: " + ex2.getMessage());
            throw ex2;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.out.close();
        }
        catch (IOException ex2) {
            this.wire.output("[close] I/O error: " + ex2.getMessage());
            throw ex2;
        }
    }
}

