/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.utils;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;

public final class ByteArrayBuilder {
    private CharsetEncoder charsetEncoder;
    private ByteBuffer buffer;

    public ByteArrayBuilder() {
    }

    public ByteArrayBuilder(int initialCapacity) {
        this.buffer = ByteBuffer.allocate(initialCapacity);
    }

    public int capacity() {
        return this.buffer != null ? this.buffer.capacity() : 0;
    }

    static ByteBuffer ensureFreeCapacity(ByteBuffer buffer, int capacity) {
        if (buffer == null) {
            return ByteBuffer.allocate(capacity);
        }
        if (buffer.remaining() < capacity) {
            ByteBuffer newBuffer = ByteBuffer.allocate(buffer.position() + capacity);
            buffer.flip();
            newBuffer.put(buffer);
            return newBuffer;
        }
        return buffer;
    }

    static ByteBuffer encode(ByteBuffer buffer, CharBuffer in2, CharsetEncoder encoder) throws CharacterCodingException {
        int capacity = (int)((float)in2.remaining() * encoder.averageBytesPerChar());
        ByteBuffer out = ByteArrayBuilder.ensureFreeCapacity(buffer, capacity);
        while (true) {
            CoderResult result;
            CoderResult coderResult = result = in2.hasRemaining() ? encoder.encode(in2, out, true) : CoderResult.UNDERFLOW;
            if (result.isError()) {
                result.throwException();
            }
            if (result.isUnderflow()) {
                result = encoder.flush(out);
            }
            if (result.isUnderflow()) break;
            if (!result.isOverflow()) continue;
            out = ByteArrayBuilder.ensureFreeCapacity(out, capacity);
        }
        return out;
    }

    public void ensureFreeCapacity(int freeCapacity) {
        this.buffer = ByteArrayBuilder.ensureFreeCapacity(this.buffer, freeCapacity);
    }

    private void doAppend(CharBuffer charBuffer) {
        if (this.charsetEncoder == null) {
            this.charsetEncoder = StandardCharsets.US_ASCII.newEncoder().onMalformedInput(CodingErrorAction.IGNORE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        this.charsetEncoder.reset();
        try {
            this.buffer = ByteArrayBuilder.encode(this.buffer, charBuffer, this.charsetEncoder);
        }
        catch (CharacterCodingException ex2) {
            throw new IllegalStateException("Unexpected character coding error", ex2);
        }
    }

    public ByteArrayBuilder charset(Charset charset) {
        this.charsetEncoder = charset == null ? null : charset.newEncoder().onMalformedInput(CodingErrorAction.IGNORE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        return this;
    }

    public ByteArrayBuilder append(byte[] b10, int off, int len) {
        if (b10 == null) {
            return this;
        }
        if (off < 0 || off > b10.length || len < 0 || off + len < 0 || off + len > b10.length) {
            throw new IndexOutOfBoundsException("off: " + off + " len: " + len + " b.length: " + b10.length);
        }
        this.ensureFreeCapacity(len);
        this.buffer.put(b10, off, len);
        return this;
    }

    public ByteArrayBuilder append(byte[] b10) {
        if (b10 == null) {
            return this;
        }
        return this.append(b10, 0, b10.length);
    }

    public ByteArrayBuilder append(CharBuffer charBuffer) {
        if (charBuffer == null) {
            return this;
        }
        this.doAppend(charBuffer);
        return this;
    }

    public ByteArrayBuilder append(char[] b10, int off, int len) {
        if (b10 == null) {
            return this;
        }
        if (off < 0 || off > b10.length || len < 0 || off + len < 0 || off + len > b10.length) {
            throw new IndexOutOfBoundsException("off: " + off + " len: " + len + " b.length: " + b10.length);
        }
        return this.append(CharBuffer.wrap(b10, off, len));
    }

    public ByteArrayBuilder append(char[] b10) {
        if (b10 == null) {
            return this;
        }
        return this.append(b10, 0, b10.length);
    }

    public ByteArrayBuilder append(String s10) {
        if (s10 == null) {
            return this;
        }
        return this.append(CharBuffer.wrap(s10));
    }

    public ByteBuffer toByteBuffer() {
        return this.buffer != null ? this.buffer.duplicate() : ByteBuffer.allocate(0);
    }

    public byte[] toByteArray() {
        if (this.buffer == null) {
            return new byte[0];
        }
        this.buffer.flip();
        byte[] b10 = new byte[this.buffer.remaining()];
        this.buffer.get(b10);
        this.buffer.clear();
        return b10;
    }

    public void reset() {
        if (this.charsetEncoder != null) {
            this.charsetEncoder.reset();
        }
        if (this.buffer != null) {
            this.buffer.clear();
        }
    }

    public String toString() {
        return this.buffer != null ? this.buffer.toString() : "null";
    }
}

