/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.HeaderValueFormatter;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicHeaderValueFormatter
implements HeaderValueFormatter {
    public static final BasicHeaderValueFormatter INSTANCE = new BasicHeaderValueFormatter();
    private static final String SEPARATORS = " ;,:@()<>\\\"/[]?={}\t";
    private static final String UNSAFE_CHARS = "\"\\";

    @Override
    public void formatElements(CharArrayBuffer buffer, HeaderElement[] elems, boolean quote) {
        Args.notNull(buffer, "Char array buffer");
        Args.notNull(elems, "Header element array");
        for (int i10 = 0; i10 < elems.length; ++i10) {
            if (i10 > 0) {
                buffer.append(", ");
            }
            this.formatHeaderElement(buffer, elems[i10], quote);
        }
    }

    @Override
    public void formatHeaderElement(CharArrayBuffer buffer, HeaderElement elem, boolean quote) {
        int c10;
        Args.notNull(buffer, "Char array buffer");
        Args.notNull(elem, "Header element");
        buffer.append(elem.getName());
        String value = elem.getValue();
        if (value != null) {
            buffer.append('=');
            this.formatValue(buffer, value, quote);
        }
        if ((c10 = elem.getParameterCount()) > 0) {
            for (int i10 = 0; i10 < c10; ++i10) {
                buffer.append("; ");
                this.formatNameValuePair(buffer, elem.getParameter(i10), quote);
            }
        }
    }

    @Override
    public void formatParameters(CharArrayBuffer buffer, NameValuePair[] nvps, boolean quote) {
        Args.notNull(buffer, "Char array buffer");
        Args.notNull(nvps, "Header parameter array");
        for (int i10 = 0; i10 < nvps.length; ++i10) {
            if (i10 > 0) {
                buffer.append("; ");
            }
            this.formatNameValuePair(buffer, nvps[i10], quote);
        }
    }

    @Override
    public void formatNameValuePair(CharArrayBuffer buffer, NameValuePair nvp, boolean quote) {
        Args.notNull(buffer, "Char array buffer");
        Args.notNull(nvp, "Name / value pair");
        buffer.append(nvp.getName());
        String value = nvp.getValue();
        if (value != null) {
            buffer.append('=');
            this.formatValue(buffer, value, quote);
        }
    }

    void formatValue(CharArrayBuffer buffer, String value, boolean quote) {
        int i10;
        boolean quoteFlag = quote;
        if (!quoteFlag) {
            for (i10 = 0; i10 < value.length() && !quoteFlag; ++i10) {
                quoteFlag = this.isSeparator(value.charAt(i10));
            }
        }
        if (quoteFlag) {
            buffer.append('\"');
        }
        for (i10 = 0; i10 < value.length(); ++i10) {
            char ch2 = value.charAt(i10);
            if (this.isUnsafe(ch2)) {
                buffer.append('\\');
            }
            buffer.append(ch2);
        }
        if (quoteFlag) {
            buffer.append('\"');
        }
    }

    boolean isSeparator(char ch2) {
        return SEPARATORS.indexOf(ch2) >= 0;
    }

    boolean isUnsafe(char ch2) {
        return UNSAFE_CHARS.indexOf(ch2) >= 0;
    }
}

