/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support.classic;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hc.core5.http.nio.support.classic.ContentOutputBuffer;
import org.apache.hc.core5.util.Args;

public class ContentOutputStream
extends OutputStream {
    private final ContentOutputBuffer buffer;

    public ContentOutputStream(ContentOutputBuffer buffer) {
        Args.notNull(buffer, "Output buffer");
        this.buffer = buffer;
    }

    @Override
    public void close() throws IOException {
        this.buffer.writeCompleted();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void write(byte[] b10, int off, int len) throws IOException {
        this.buffer.write(b10, off, len);
    }

    @Override
    public void write(byte[] b10) throws IOException {
        if (b10 == null) {
            return;
        }
        this.buffer.write(b10, 0, b10.length);
    }

    @Override
    public void write(int b10) throws IOException {
        this.buffer.write(b10);
    }
}

