/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.protocol;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class BasicHttpContext
implements HttpContext {
    private final HttpContext parentContext;
    private final Map<String, Object> map = new ConcurrentHashMap<String, Object>();
    private ProtocolVersion version;

    public BasicHttpContext() {
        this(null);
    }

    public BasicHttpContext(HttpContext parentContext) {
        this.parentContext = parentContext;
    }

    @Override
    public Object getAttribute(String id2) {
        Args.notNull(id2, "Id");
        Object obj = this.map.get(id2);
        if (obj == null && this.parentContext != null) {
            obj = this.parentContext.getAttribute(id2);
        }
        return obj;
    }

    @Override
    public Object setAttribute(String id2, Object obj) {
        Args.notNull(id2, "Id");
        if (obj != null) {
            return this.map.put(id2, obj);
        }
        return this.map.remove(id2);
    }

    @Override
    public Object removeAttribute(String id2) {
        Args.notNull(id2, "Id");
        return this.map.remove(id2);
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.version != null ? this.version : HttpVersion.DEFAULT;
    }

    @Override
    public void setProtocolVersion(ProtocolVersion version) {
        this.version = version;
    }

    public void clear() {
        this.map.clear();
    }

    public String toString() {
        return this.map.toString();
    }
}

