/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.protocol;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

final class ChainBuilder<E> {
    private final LinkedList<E> list = new LinkedList();
    private final Map<Class<?>, E> uniqueClasses = new HashMap();

    private void ensureUnique(E e10) {
        E previous = this.uniqueClasses.remove(e10.getClass());
        if (previous != null) {
            this.list.remove(previous);
        }
        this.uniqueClasses.put(e10.getClass(), e10);
    }

    public ChainBuilder<E> addFirst(E e10) {
        if (e10 == null) {
            return this;
        }
        this.ensureUnique(e10);
        this.list.addFirst(e10);
        return this;
    }

    public ChainBuilder<E> addLast(E e10) {
        if (e10 == null) {
            return this;
        }
        this.ensureUnique(e10);
        this.list.addLast(e10);
        return this;
    }

    public ChainBuilder<E> addAllFirst(Collection<E> c10) {
        if (c10 == null) {
            return this;
        }
        for (E e10 : c10) {
            this.addFirst(e10);
        }
        return this;
    }

    @SafeVarargs
    public final ChainBuilder<E> addAllFirst(E ... c10) {
        if (c10 == null) {
            return this;
        }
        for (E e10 : c10) {
            this.addFirst(e10);
        }
        return this;
    }

    public ChainBuilder<E> addAllLast(Collection<E> c10) {
        if (c10 == null) {
            return this;
        }
        for (E e10 : c10) {
            this.addLast(e10);
        }
        return this;
    }

    @SafeVarargs
    public final ChainBuilder<E> addAllLast(E ... c10) {
        if (c10 == null) {
            return this;
        }
        for (E e10 : c10) {
            this.addLast(e10);
        }
        return this;
    }

    public LinkedList<E> build() {
        return new LinkedList<E>(this.list);
    }
}

