/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.protocol;

import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.protocol.ChainBuilder;
import org.apache.hc.core5.http.protocol.DefaultHttpProcessor;
import org.apache.hc.core5.http.protocol.HttpProcessor;

public class HttpProcessorBuilder {
    private ChainBuilder<HttpRequestInterceptor> requestChainBuilder;
    private ChainBuilder<HttpResponseInterceptor> responseChainBuilder;

    public static HttpProcessorBuilder create() {
        return new HttpProcessorBuilder();
    }

    HttpProcessorBuilder() {
    }

    private ChainBuilder<HttpRequestInterceptor> getRequestChainBuilder() {
        if (this.requestChainBuilder == null) {
            this.requestChainBuilder = new ChainBuilder();
        }
        return this.requestChainBuilder;
    }

    private ChainBuilder<HttpResponseInterceptor> getResponseChainBuilder() {
        if (this.responseChainBuilder == null) {
            this.responseChainBuilder = new ChainBuilder();
        }
        return this.responseChainBuilder;
    }

    public HttpProcessorBuilder addFirst(HttpRequestInterceptor e10) {
        if (e10 == null) {
            return this;
        }
        this.getRequestChainBuilder().addFirst(e10);
        return this;
    }

    public HttpProcessorBuilder addLast(HttpRequestInterceptor e10) {
        if (e10 == null) {
            return this;
        }
        this.getRequestChainBuilder().addLast(e10);
        return this;
    }

    public HttpProcessorBuilder add(HttpRequestInterceptor e10) {
        return this.addLast(e10);
    }

    public HttpProcessorBuilder addAllFirst(HttpRequestInterceptor ... e10) {
        if (e10 == null) {
            return this;
        }
        this.getRequestChainBuilder().addAllFirst((HttpRequestInterceptor[])e10);
        return this;
    }

    public HttpProcessorBuilder addAllLast(HttpRequestInterceptor ... e10) {
        if (e10 == null) {
            return this;
        }
        this.getRequestChainBuilder().addAllLast((HttpRequestInterceptor[])e10);
        return this;
    }

    public HttpProcessorBuilder addAll(HttpRequestInterceptor ... e10) {
        return this.addAllLast(e10);
    }

    public HttpProcessorBuilder addFirst(HttpResponseInterceptor e10) {
        if (e10 == null) {
            return this;
        }
        this.getResponseChainBuilder().addFirst(e10);
        return this;
    }

    public HttpProcessorBuilder addLast(HttpResponseInterceptor e10) {
        if (e10 == null) {
            return this;
        }
        this.getResponseChainBuilder().addLast(e10);
        return this;
    }

    public HttpProcessorBuilder add(HttpResponseInterceptor e10) {
        return this.addLast(e10);
    }

    public HttpProcessorBuilder addAllFirst(HttpResponseInterceptor ... e10) {
        if (e10 == null) {
            return this;
        }
        this.getResponseChainBuilder().addAllFirst((HttpResponseInterceptor[])e10);
        return this;
    }

    public HttpProcessorBuilder addAllLast(HttpResponseInterceptor ... e10) {
        if (e10 == null) {
            return this;
        }
        this.getResponseChainBuilder().addAllLast((HttpResponseInterceptor[])e10);
        return this;
    }

    public HttpProcessorBuilder addAll(HttpResponseInterceptor ... e10) {
        return this.addAllLast(e10);
    }

    public HttpProcessor build() {
        return new DefaultHttpProcessor(this.requestChainBuilder != null ? this.requestChainBuilder.build() : null, this.responseChainBuilder != null ? this.responseChainBuilder.build() : null);
    }
}

