/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.ssl;

import java.util.BitSet;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.http.message.TokenParser;

final class TlsVersionParser {
    public static final TlsVersionParser INSTANCE = new TlsVersionParser();
    private final TokenParser tokenParser = TokenParser.INSTANCE;

    TlsVersionParser() {
    }

    ProtocolVersion parse(CharSequence buffer, ParserCursor cursor, BitSet delimiters) throws ParseException {
        int minor;
        int major;
        int lowerBound = cursor.getLowerBound();
        int upperBound = cursor.getUpperBound();
        int pos = cursor.getPos();
        if (pos + 4 > cursor.getUpperBound()) {
            throw new ParseException("Invalid TLS protocol version", buffer, lowerBound, upperBound, pos);
        }
        if (buffer.charAt(pos) != 'T' || buffer.charAt(pos + 1) != 'L' || buffer.charAt(pos + 2) != 'S' || buffer.charAt(pos + 3) != 'v') {
            throw new ParseException("Invalid TLS protocol version", buffer, lowerBound, upperBound, pos);
        }
        cursor.updatePos(pos += 4);
        if (cursor.atEnd()) {
            throw new ParseException("Invalid TLS version", buffer, lowerBound, upperBound, pos);
        }
        String s10 = this.tokenParser.parseToken(buffer, cursor, delimiters);
        int idx = s10.indexOf(46);
        if (idx == -1) {
            int major2;
            try {
                major2 = Integer.parseInt(s10);
            }
            catch (NumberFormatException e10) {
                throw new ParseException("Invalid TLS major version", buffer, lowerBound, upperBound, pos);
            }
            return new ProtocolVersion("TLS", major2, 0);
        }
        String s12 = s10.substring(0, idx);
        try {
            major = Integer.parseInt(s12);
        }
        catch (NumberFormatException e11) {
            throw new ParseException("Invalid TLS major version", buffer, lowerBound, upperBound, pos);
        }
        String s22 = s10.substring(idx + 1);
        try {
            minor = Integer.parseInt(s22);
        }
        catch (NumberFormatException e12) {
            throw new ParseException("Invalid TLS minor version", buffer, lowerBound, upperBound, pos);
        }
        return new ProtocolVersion("TLS", major, minor);
    }

    ProtocolVersion parse(String s10) throws ParseException {
        if (s10 == null) {
            return null;
        }
        ParserCursor cursor = new ParserCursor(0, s10.length());
        return this.parse(s10, cursor, null);
    }
}

