/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.net;

import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.http.message.TokenParser;
import org.apache.hc.core5.util.Args;

public class URLEncodedUtils {
    private static final char QP_SEP_A = '&';
    private static final char QP_SEP_S = ';';
    private static final String NAME_VALUE_SEPARATOR = "=";
    private static final char PATH_SEPARATOR = '/';
    private static final BitSet PATH_SEPARATORS;
    private static final BitSet UNRESERVED;
    private static final BitSet PUNCT;
    private static final BitSet USERINFO;
    private static final BitSet PATHSAFE;
    private static final BitSet URIC;
    private static final BitSet RESERVED;
    private static final BitSet URLENCODER;
    private static final BitSet PATH_SPECIAL;
    private static final int RADIX = 16;

    public static List<NameValuePair> parse(URI uri, Charset charset) {
        Args.notNull(uri, "URI");
        String query = uri.getRawQuery();
        if (query != null && !query.isEmpty()) {
            return URLEncodedUtils.parse(query, charset);
        }
        return URLEncodedUtils.createEmptyList();
    }

    public static List<NameValuePair> parse(CharSequence s10, Charset charset) {
        if (s10 == null) {
            return URLEncodedUtils.createEmptyList();
        }
        return URLEncodedUtils.parse(s10, charset, '&', ';');
    }

    public static List<NameValuePair> parse(CharSequence s10, Charset charset, char ... separators) {
        Args.notNull(s10, "Char sequence");
        TokenParser tokenParser = TokenParser.INSTANCE;
        BitSet delimSet = new BitSet();
        for (char separator : separators) {
            delimSet.set(separator);
        }
        ParserCursor cursor = new ParserCursor(0, s10.length());
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        while (!cursor.atEnd()) {
            delimSet.set(61);
            String name = tokenParser.parseToken(s10, cursor, delimSet);
            String value = null;
            if (!cursor.atEnd()) {
                char delim = s10.charAt(cursor.getPos());
                cursor.updatePos(cursor.getPos() + 1);
                if (delim == '=') {
                    delimSet.clear(61);
                    value = tokenParser.parseToken(s10, cursor, delimSet);
                    if (!cursor.atEnd()) {
                        cursor.updatePos(cursor.getPos() + 1);
                    }
                }
            }
            if (name.isEmpty()) continue;
            list.add(new BasicNameValuePair(URLEncodedUtils.decodeFormFields(name, charset), URLEncodedUtils.decodeFormFields(value, charset)));
        }
        return list;
    }

    static List<String> splitSegments(CharSequence s10, BitSet separators) {
        ParserCursor cursor = new ParserCursor(0, s10.length());
        if (cursor.atEnd()) {
            return Collections.emptyList();
        }
        if (separators.get(s10.charAt(cursor.getPos()))) {
            cursor.updatePos(cursor.getPos() + 1);
        }
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        while (true) {
            if (cursor.atEnd()) break;
            char current = s10.charAt(cursor.getPos());
            if (separators.get(current)) {
                list.add(buf.toString());
                buf.setLength(0);
            } else {
                buf.append(current);
            }
            cursor.updatePos(cursor.getPos() + 1);
        }
        list.add(buf.toString());
        return list;
    }

    static List<String> splitPathSegments(CharSequence s10) {
        return URLEncodedUtils.splitSegments(s10, PATH_SEPARATORS);
    }

    public static List<String> parsePathSegments(CharSequence s10, Charset charset) {
        Args.notNull(s10, "Char sequence");
        List<String> list = URLEncodedUtils.splitPathSegments(s10);
        for (int i10 = 0; i10 < list.size(); ++i10) {
            list.set(i10, URLEncodedUtils.urlDecode(list.get(i10), charset != null ? charset : StandardCharsets.UTF_8, false));
        }
        return list;
    }

    public static List<String> parsePathSegments(CharSequence s10) {
        return URLEncodedUtils.parsePathSegments(s10, StandardCharsets.UTF_8);
    }

    static void formatSegments(StringBuilder buf, Iterable<String> segments, Charset charset) {
        for (String segment : segments) {
            buf.append('/');
            URLEncodedUtils.urlEncode(buf, segment, charset, PATHSAFE, false);
        }
    }

    public static String formatSegments(Iterable<String> segments, Charset charset) {
        Args.notNull(segments, "Segments");
        StringBuilder buf = new StringBuilder();
        URLEncodedUtils.formatSegments(buf, segments, charset);
        return buf.toString();
    }

    public static String formatSegments(String ... segments) {
        return URLEncodedUtils.formatSegments(Arrays.asList(segments), StandardCharsets.UTF_8);
    }

    static void formatNameValuePairs(StringBuilder buf, Iterable<? extends NameValuePair> parameters, char parameterSeparator, Charset charset) {
        int i10 = 0;
        for (NameValuePair nameValuePair : parameters) {
            if (i10 > 0) {
                buf.append(parameterSeparator);
            }
            URLEncodedUtils.encodeFormFields(buf, nameValuePair.getName(), charset);
            if (nameValuePair.getValue() != null) {
                buf.append(NAME_VALUE_SEPARATOR);
                URLEncodedUtils.encodeFormFields(buf, nameValuePair.getValue(), charset);
            }
            ++i10;
        }
    }

    static void formatParameters(StringBuilder buf, Iterable<? extends NameValuePair> parameters, Charset charset) {
        URLEncodedUtils.formatNameValuePairs(buf, parameters, '&', charset);
    }

    public static String format(Iterable<? extends NameValuePair> parameters, char parameterSeparator, Charset charset) {
        Args.notNull(parameters, "Parameters");
        StringBuilder buf = new StringBuilder();
        URLEncodedUtils.formatNameValuePairs(buf, parameters, parameterSeparator, charset);
        return buf.toString();
    }

    public static String format(Iterable<? extends NameValuePair> parameters, Charset charset) {
        return URLEncodedUtils.format(parameters, '&', charset);
    }

    private static List<NameValuePair> createEmptyList() {
        return new ArrayList<NameValuePair>(0);
    }

    private static void urlEncode(StringBuilder buf, String content, Charset charset, BitSet safechars, boolean blankAsPlus) {
        if (content == null) {
            return;
        }
        ByteBuffer bb2 = charset.encode(content);
        while (bb2.hasRemaining()) {
            int b10 = bb2.get() & 0xFF;
            if (safechars.get(b10)) {
                buf.append((char)b10);
                continue;
            }
            if (blankAsPlus && b10 == 32) {
                buf.append('+');
                continue;
            }
            buf.append("%");
            char hex1 = Character.toUpperCase(Character.forDigit(b10 >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b10 & 0xF, 16));
            buf.append(hex1);
            buf.append(hex2);
        }
    }

    private static String urlDecode(String content, Charset charset, boolean plusAsBlank) {
        if (content == null) {
            return null;
        }
        ByteBuffer bb2 = ByteBuffer.allocate(content.length());
        CharBuffer cb2 = CharBuffer.wrap(content);
        while (cb2.hasRemaining()) {
            char c10 = cb2.get();
            if (c10 == '%' && cb2.remaining() >= 2) {
                char uc2 = cb2.get();
                char lc2 = cb2.get();
                int u10 = Character.digit(uc2, 16);
                int l10 = Character.digit(lc2, 16);
                if (u10 != -1 && l10 != -1) {
                    bb2.put((byte)((u10 << 4) + l10));
                    continue;
                }
                bb2.put((byte)37);
                bb2.put((byte)uc2);
                bb2.put((byte)lc2);
                continue;
            }
            if (plusAsBlank && c10 == '+') {
                bb2.put((byte)32);
                continue;
            }
            bb2.put((byte)c10);
        }
        bb2.flip();
        return charset.decode(bb2).toString();
    }

    static String decodeFormFields(String content, Charset charset) {
        if (content == null) {
            return null;
        }
        return URLEncodedUtils.urlDecode(content, charset != null ? charset : StandardCharsets.UTF_8, true);
    }

    static void encodeFormFields(StringBuilder buf, String content, Charset charset) {
        if (content == null) {
            return;
        }
        URLEncodedUtils.urlEncode(buf, content, charset != null ? charset : StandardCharsets.UTF_8, URLENCODER, true);
    }

    static void encUserInfo(StringBuilder buf, String content, Charset charset) {
        URLEncodedUtils.urlEncode(buf, content, charset != null ? charset : StandardCharsets.UTF_8, USERINFO, false);
    }

    static void encUric(StringBuilder buf, String content, Charset charset) {
        URLEncodedUtils.urlEncode(buf, content, charset != null ? charset : StandardCharsets.UTF_8, URIC, false);
    }

    static {
        int i10;
        PATH_SEPARATORS = new BitSet(256);
        PATH_SEPARATORS.set(47);
        UNRESERVED = new BitSet(256);
        PUNCT = new BitSet(256);
        USERINFO = new BitSet(256);
        PATHSAFE = new BitSet(256);
        URIC = new BitSet(256);
        RESERVED = new BitSet(256);
        URLENCODER = new BitSet(256);
        PATH_SPECIAL = new BitSet(256);
        for (i10 = 97; i10 <= 122; ++i10) {
            UNRESERVED.set(i10);
        }
        for (i10 = 65; i10 <= 90; ++i10) {
            UNRESERVED.set(i10);
        }
        for (i10 = 48; i10 <= 57; ++i10) {
            UNRESERVED.set(i10);
        }
        UNRESERVED.set(95);
        UNRESERVED.set(45);
        UNRESERVED.set(46);
        UNRESERVED.set(42);
        URLENCODER.or(UNRESERVED);
        UNRESERVED.set(33);
        UNRESERVED.set(126);
        UNRESERVED.set(39);
        UNRESERVED.set(40);
        UNRESERVED.set(41);
        PUNCT.set(44);
        PUNCT.set(59);
        PUNCT.set(58);
        PUNCT.set(36);
        PUNCT.set(38);
        PUNCT.set(43);
        PUNCT.set(61);
        USERINFO.or(UNRESERVED);
        USERINFO.or(PUNCT);
        PATHSAFE.or(UNRESERVED);
        PATHSAFE.set(59);
        PATHSAFE.set(58);
        PATHSAFE.set(64);
        PATHSAFE.set(38);
        PATHSAFE.set(61);
        PATHSAFE.set(43);
        PATHSAFE.set(36);
        PATHSAFE.set(44);
        PATH_SPECIAL.or(PATHSAFE);
        PATH_SPECIAL.set(47);
        RESERVED.set(59);
        RESERVED.set(47);
        RESERVED.set(63);
        RESERVED.set(58);
        RESERVED.set(64);
        RESERVED.set(38);
        RESERVED.set(61);
        RESERVED.set(43);
        RESERVED.set(36);
        RESERVED.set(44);
        RESERVED.set(91);
        RESERVED.set(93);
        URIC.or(RESERVED);
        URIC.or(UNRESERVED);
    }
}

