/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.reactor.IOReactor;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;

class MultiCoreIOReactor
implements IOReactor {
    private final IOReactor[] ioReactors;
    private final Thread[] threads;
    private final AtomicReference<IOReactorStatus> status;

    MultiCoreIOReactor(IOReactor[] ioReactors, Thread[] threads) {
        this.ioReactors = (IOReactor[])ioReactors.clone();
        this.threads = (Thread[])threads.clone();
        this.status = new AtomicReference<IOReactorStatus>(IOReactorStatus.INACTIVE);
    }

    @Override
    public IOReactorStatus getStatus() {
        return this.status.get();
    }

    public final void start() {
        if (this.status.compareAndSet(IOReactorStatus.INACTIVE, IOReactorStatus.ACTIVE)) {
            for (int i10 = 0; i10 < this.threads.length; ++i10) {
                this.threads[i10].start();
            }
        }
    }

    @Override
    public final void initiateShutdown() {
        if (this.status.compareAndSet(IOReactorStatus.ACTIVE, IOReactorStatus.SHUTTING_DOWN)) {
            for (int i10 = 0; i10 < this.ioReactors.length; ++i10) {
                IOReactor ioReactor = this.ioReactors[i10];
                ioReactor.initiateShutdown();
            }
        }
    }

    @Override
    public final void awaitShutdown(TimeValue waitTime) throws InterruptedException {
        int i10;
        Args.notNull(waitTime, "Wait time");
        long deadline = System.currentTimeMillis() + waitTime.toMilliseconds();
        long remaining = waitTime.toMilliseconds();
        for (i10 = 0; i10 < this.ioReactors.length; ++i10) {
            IOReactor ioReactor = this.ioReactors[i10];
            if (ioReactor.getStatus().compareTo(IOReactorStatus.SHUT_DOWN) >= 0) continue;
            ioReactor.awaitShutdown(TimeValue.of(remaining, TimeUnit.MILLISECONDS));
            remaining = deadline - System.currentTimeMillis();
            if (remaining > 0L) continue;
            return;
        }
        for (i10 = 0; i10 < this.threads.length; ++i10) {
            Thread thread = this.threads[i10];
            thread.join(remaining);
            remaining = deadline - System.currentTimeMillis();
            if (remaining > 0L) continue;
            return;
        }
    }

    @Override
    public final void close(CloseMode closeMode) {
        IOReactorStatus currentStatus = this.status.get();
        if (currentStatus == IOReactorStatus.INACTIVE || currentStatus == IOReactorStatus.SHUT_DOWN) {
            return;
        }
        if (closeMode == CloseMode.GRACEFUL) {
            this.initiateShutdown();
            try {
                this.awaitShutdown(TimeValue.ofSeconds(5L));
            }
            catch (InterruptedException e10) {
                Thread.currentThread().interrupt();
            }
        } else {
            int i10;
            this.status.compareAndSet(IOReactorStatus.ACTIVE, IOReactorStatus.SHUTTING_DOWN);
            for (i10 = 0; i10 < this.ioReactors.length; ++i10) {
                Closer.close(this.ioReactors[i10], CloseMode.IMMEDIATE);
            }
            for (i10 = 0; i10 < this.threads.length; ++i10) {
                this.threads[i10].interrupt();
            }
        }
        this.status.set(IOReactorStatus.SHUT_DOWN);
    }

    @Override
    public final void close() {
        this.close(CloseMode.GRACEFUL);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [status=" + this.status + "]";
    }
}

