/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.util;

import java.io.Serializable;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;

public final class ByteArrayBuffer
implements Serializable {
    private static final long serialVersionUID = 4359112959524048036L;
    private byte[] array;
    private int len;

    public ByteArrayBuffer(int capacity) {
        Args.notNegative(capacity, "Buffer capacity");
        this.array = new byte[capacity];
    }

    private void expand(int newlen) {
        byte[] newArray = new byte[Math.max(this.array.length << 1, newlen)];
        System.arraycopy(this.array, 0, newArray, 0, this.len);
        this.array = newArray;
    }

    public void append(byte[] b10, int off, int len) {
        if (b10 == null) {
            return;
        }
        if (off < 0 || off > b10.length || len < 0 || off + len < 0 || off + len > b10.length) {
            throw new IndexOutOfBoundsException("off: " + off + " len: " + len + " b.length: " + b10.length);
        }
        if (len == 0) {
            return;
        }
        int newlen = this.len + len;
        if (newlen > this.array.length) {
            this.expand(newlen);
        }
        System.arraycopy(b10, off, this.array, this.len, len);
        this.len = newlen;
    }

    public void append(int b10) {
        int newlen = this.len + 1;
        if (newlen > this.array.length) {
            this.expand(newlen);
        }
        this.array[this.len] = (byte)b10;
        this.len = newlen;
    }

    public void append(char[] b10, int off, int len) {
        if (b10 == null) {
            return;
        }
        if (off < 0 || off > b10.length || len < 0 || off + len < 0 || off + len > b10.length) {
            throw new IndexOutOfBoundsException("off: " + off + " len: " + len + " b.length: " + b10.length);
        }
        if (len == 0) {
            return;
        }
        int oldlen = this.len;
        int newlen = oldlen + len;
        if (newlen > this.array.length) {
            this.expand(newlen);
        }
        int i12 = off;
        for (int i22 = oldlen; i22 < newlen; ++i22) {
            char c10 = b10[i12];
            this.array[i22] = c10 >= ' ' && c10 <= '~' || c10 >= '\u00a0' && c10 <= '\u00ff' || c10 == '\t' ? (int)c10 : 63;
            ++i12;
        }
        this.len = newlen;
    }

    public void append(CharArrayBuffer b10, int off, int len) {
        if (b10 == null) {
            return;
        }
        this.append(b10.array(), off, len);
    }

    public void clear() {
        this.len = 0;
    }

    public byte[] toByteArray() {
        byte[] b10 = new byte[this.len];
        if (this.len > 0) {
            System.arraycopy(this.array, 0, b10, 0, this.len);
        }
        return b10;
    }

    public int byteAt(int i10) {
        return this.array[i10];
    }

    public int capacity() {
        return this.array.length;
    }

    public int length() {
        return this.len;
    }

    public void ensureCapacity(int required) {
        if (required <= 0) {
            return;
        }
        int available = this.array.length - this.len;
        if (required > available) {
            this.expand(this.len + required);
        }
    }

    public byte[] array() {
        return this.array;
    }

    public void setLength(int len) {
        if (len < 0 || len > this.array.length) {
            throw new IndexOutOfBoundsException("len: " + len + " < 0 or > buffer len: " + this.array.length);
        }
        this.len = len;
    }

    public boolean isEmpty() {
        return this.len == 0;
    }

    public boolean isFull() {
        return this.len == this.array.length;
    }

    public int indexOf(byte b10, int from, int to2) {
        int endIndex;
        int beginIndex = from;
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if ((endIndex = to2) > this.len) {
            endIndex = this.len;
        }
        if (beginIndex > endIndex) {
            return -1;
        }
        for (int i10 = beginIndex; i10 < endIndex; ++i10) {
            if (this.array[i10] != b10) continue;
            return i10;
        }
        return -1;
    }

    public int indexOf(byte b10) {
        return this.indexOf(b10, 0, this.len);
    }
}

