/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.CategoryKey;
import org.apache.log4j.DefaultCategoryFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.ProvisionNode;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.or.ObjectRenderer;
import org.apache.log4j.or.RendererMap;
import org.apache.log4j.spi.HierarchyEventListener;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RendererSupport;

public class Hierarchy
implements LoggerRepository,
RendererSupport {
    private LoggerFactory defaultFactory;
    private Vector listeners;
    Hashtable ht = new Hashtable();
    Logger root;
    RendererMap rendererMap;
    int thresholdInt;
    Level threshold;
    boolean emittedNoAppenderWarning = false;
    boolean emittedNoResourceBundleWarning = false;

    public Hierarchy(Logger root) {
        this.listeners = new Vector(1);
        this.root = root;
        this.setThreshold(Level.ALL);
        this.root.setHierarchy(this);
        this.rendererMap = new RendererMap();
        this.defaultFactory = new DefaultCategoryFactory();
    }

    public void addRenderer(Class classToRender, ObjectRenderer or2) {
        this.rendererMap.put(classToRender, or2);
    }

    public void addHierarchyEventListener(HierarchyEventListener listener) {
        if (this.listeners.contains(listener)) {
            LogLog.warn("Ignoring attempt to add an existent listener.");
        } else {
            this.listeners.addElement(listener);
        }
    }

    public void clear() {
        this.ht.clear();
    }

    public void emitNoAppenderWarning(Category cat) {
        if (!this.emittedNoAppenderWarning) {
            LogLog.warn("No appenders could be found for logger (" + cat.getName() + ").");
            LogLog.warn("Please initialize the log4j system properly.");
            this.emittedNoAppenderWarning = true;
        }
    }

    public Logger exists(String name) {
        Object o10 = this.ht.get(new CategoryKey(name));
        if (o10 instanceof Logger) {
            return (Logger)o10;
        }
        return null;
    }

    public void setThreshold(String levelStr) {
        Level l10 = Level.toLevel(levelStr, null);
        if (l10 != null) {
            this.setThreshold(l10);
        } else {
            LogLog.warn("Could not convert [" + levelStr + "] to Level.");
        }
    }

    public void setThreshold(Level l10) {
        if (l10 != null) {
            this.thresholdInt = l10.level;
            this.threshold = l10;
        }
    }

    public void fireAddAppenderEvent(Category logger, Appender appender) {
        if (this.listeners != null) {
            int size = this.listeners.size();
            int i10 = 0;
            while (i10 < size) {
                HierarchyEventListener listener = (HierarchyEventListener)this.listeners.elementAt(i10);
                listener.addAppenderEvent(logger, appender);
                ++i10;
            }
        }
    }

    void fireRemoveAppenderEvent(Category logger, Appender appender) {
        if (this.listeners != null) {
            int size = this.listeners.size();
            int i10 = 0;
            while (i10 < size) {
                HierarchyEventListener listener = (HierarchyEventListener)this.listeners.elementAt(i10);
                listener.removeAppenderEvent(logger, appender);
                ++i10;
            }
        }
    }

    public Level getThreshold() {
        return this.threshold;
    }

    public Logger getLogger(String name) {
        return this.getLogger(name, this.defaultFactory);
    }

    public Logger getLogger(String name, LoggerFactory factory) {
        CategoryKey key = new CategoryKey(name);
        Hashtable hashtable = this.ht;
        synchronized (hashtable) {
            Object o10 = this.ht.get(key);
            if (o10 == null) {
                Logger logger = factory.makeNewLoggerInstance(name);
                logger.setHierarchy(this);
                this.ht.put(key, logger);
                this.updateParents(logger);
                Logger logger2 = logger;
                return logger2;
            }
            if (o10 instanceof Logger) {
                Logger logger = (Logger)o10;
                return logger;
            }
            if (o10 instanceof ProvisionNode) {
                Logger logger = factory.makeNewLoggerInstance(name);
                logger.setHierarchy(this);
                this.ht.put(key, logger);
                this.updateChildren((ProvisionNode)o10, logger);
                this.updateParents(logger);
                Logger logger3 = logger;
                return logger3;
            }
            Logger logger = null;
            return logger;
        }
    }

    public Enumeration getCurrentLoggers() {
        Vector v10 = new Vector(this.ht.size());
        Enumeration elems = this.ht.elements();
        while (elems.hasMoreElements()) {
            Object o10 = elems.nextElement();
            if (!(o10 instanceof Logger)) continue;
            v10.addElement(o10);
        }
        return v10.elements();
    }

    public Enumeration getCurrentCategories() {
        return this.getCurrentLoggers();
    }

    public RendererMap getRendererMap() {
        return this.rendererMap;
    }

    public Logger getRootLogger() {
        return this.root;
    }

    public boolean isDisabled(int level) {
        return this.thresholdInt > level;
    }

    public void overrideAsNeeded(String override) {
        LogLog.warn("The Hiearchy.overrideAsNeeded method has been deprecated.");
    }

    public void resetConfiguration() {
        this.getRootLogger().setLevel(Level.DEBUG);
        this.root.setResourceBundle(null);
        this.setThreshold(Level.ALL);
        Hashtable hashtable = this.ht;
        synchronized (hashtable) {
            this.shutdown();
            Enumeration cats = this.getCurrentLoggers();
            while (cats.hasMoreElements()) {
                Logger c10 = (Logger)cats.nextElement();
                c10.setLevel(null);
                c10.setAdditivity(true);
                c10.setResourceBundle(null);
            }
        }
        this.rendererMap.clear();
    }

    public void setDisableOverride(String override) {
        LogLog.warn("The Hiearchy.setDisableOverride method has been deprecated.");
    }

    public void setRenderer(Class renderedClass, ObjectRenderer renderer) {
        this.rendererMap.put(renderedClass, renderer);
    }

    public void shutdown() {
        Logger root = this.getRootLogger();
        root.closeNestedAppenders();
        Hashtable hashtable = this.ht;
        synchronized (hashtable) {
            Logger c10;
            Enumeration cats = this.getCurrentLoggers();
            while (cats.hasMoreElements()) {
                c10 = (Logger)cats.nextElement();
                c10.closeNestedAppenders();
            }
            root.removeAllAppenders();
            cats = this.getCurrentLoggers();
            while (cats.hasMoreElements()) {
                c10 = (Logger)cats.nextElement();
                c10.removeAllAppenders();
            }
        }
    }

    private final void updateParents(Logger cat) {
        String name = cat.name;
        int length = name.length();
        boolean parentFound = false;
        int i10 = name.lastIndexOf(46, length - 1);
        while (i10 >= 0) {
            String substr = name.substring(0, i10);
            CategoryKey key = new CategoryKey(substr);
            Object o10 = this.ht.get(key);
            if (o10 == null) {
                ProvisionNode pn2 = new ProvisionNode(cat);
                this.ht.put(key, pn2);
            } else {
                if (o10 instanceof Category) {
                    parentFound = true;
                    cat.parent = (Category)o10;
                    break;
                }
                if (o10 instanceof ProvisionNode) {
                    ((ProvisionNode)o10).addElement(cat);
                } else {
                    IllegalStateException e10 = new IllegalStateException("unexpected object type " + o10.getClass() + " in ht.");
                    e10.printStackTrace();
                }
            }
            i10 = name.lastIndexOf(46, i10 - 1);
        }
        if (!parentFound) {
            cat.parent = this.root;
        }
    }

    private final void updateChildren(ProvisionNode pn2, Logger logger) {
        int last = pn2.size();
        int i10 = 0;
        while (i10 < last) {
            Logger l10 = (Logger)pn2.elementAt(i10);
            if (!l10.parent.name.startsWith(logger.name)) {
                logger.parent = l10.parent;
                l10.parent = logger;
            }
            ++i10;
        }
    }
}

