/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.apache.log4j.Priority;

public class Level
extends Priority
implements Serializable {
    public static final int TRACE_INT = 5000;
    public static final Level OFF = new Level(Integer.MAX_VALUE, "OFF", 0);
    public static final Level FATAL = new Level(50000, "FATAL", 0);
    public static final Level ERROR = new Level(40000, "ERROR", 3);
    public static final Level WARN = new Level(30000, "WARN", 4);
    public static final Level INFO = new Level(20000, "INFO", 6);
    public static final Level DEBUG = new Level(10000, "DEBUG", 7);
    public static final Level TRACE = new Level(5000, "TRACE", 7);
    public static final Level ALL = new Level(Integer.MIN_VALUE, "ALL", 7);
    static final long serialVersionUID = 3491141966387921974L;
    static /* synthetic */ Class class$org$apache$log4j$Level;

    protected Level(int level, String levelStr, int syslogEquivalent) {
        super(level, levelStr, syslogEquivalent);
    }

    public static Level toLevel(String sArg) {
        return Level.toLevel(sArg, DEBUG);
    }

    public static Level toLevel(int val) {
        return Level.toLevel(val, DEBUG);
    }

    public static Level toLevel(int val, Level defaultLevel) {
        switch (val) {
            case -2147483648: {
                return ALL;
            }
            case 10000: {
                return DEBUG;
            }
            case 20000: {
                return INFO;
            }
            case 30000: {
                return WARN;
            }
            case 40000: {
                return ERROR;
            }
            case 50000: {
                return FATAL;
            }
            case 0x7FFFFFFF: {
                return OFF;
            }
            case 5000: {
                return TRACE;
            }
        }
        return defaultLevel;
    }

    public static Level toLevel(String sArg, Level defaultLevel) {
        if (sArg == null) {
            return defaultLevel;
        }
        String s10 = sArg.toUpperCase();
        if (s10.equals("ALL")) {
            return ALL;
        }
        if (s10.equals("DEBUG")) {
            return DEBUG;
        }
        if (s10.equals("INFO")) {
            return INFO;
        }
        if (s10.equals("WARN")) {
            return WARN;
        }
        if (s10.equals("ERROR")) {
            return ERROR;
        }
        if (s10.equals("FATAL")) {
            return FATAL;
        }
        if (s10.equals("OFF")) {
            return OFF;
        }
        if (s10.equals("TRACE")) {
            return TRACE;
        }
        return defaultLevel;
    }

    private void readObject(ObjectInputStream s10) throws IOException, ClassNotFoundException {
        s10.defaultReadObject();
        this.level = s10.readInt();
        this.syslogEquivalent = s10.readInt();
        this.levelStr = s10.readUTF();
        if (this.levelStr == null) {
            this.levelStr = "";
        }
    }

    private void writeObject(ObjectOutputStream s10) throws IOException {
        s10.defaultWriteObject();
        s10.writeInt(this.level);
        s10.writeInt(this.syslogEquivalent);
        s10.writeUTF(this.levelStr);
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.getClass() == (class$org$apache$log4j$Level == null ? (class$org$apache$log4j$Level = Level.class$("org.apache.log4j.Level")) : class$org$apache$log4j$Level)) {
            return Level.toLevel(this.level);
        }
        return this;
    }

    static /* synthetic */ Class class$(String x02) {
        try {
            return Class.forName(x02);
        }
        catch (ClassNotFoundException x12) {
            throw new NoClassDefFoundError(x12.getMessage());
        }
    }
}

