/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.helpers.LogLog;

public class NDC {
    static Hashtable ht = new Hashtable();
    static int pushCounter = 0;
    static final int REAP_THRESHOLD = 5;

    private NDC() {
    }

    private static Stack getCurrentStack() {
        if (ht != null) {
            return (Stack)ht.get(Thread.currentThread());
        }
        return null;
    }

    public static void clear() {
        Stack stack = NDC.getCurrentStack();
        if (stack != null) {
            stack.setSize(0);
        }
    }

    public static Stack cloneStack() {
        Stack stack = NDC.getCurrentStack();
        if (stack == null) {
            return null;
        }
        return (Stack)stack.clone();
    }

    public static void inherit(Stack stack) {
        if (stack != null) {
            ht.put(Thread.currentThread(), stack);
        }
    }

    public static String get() {
        Stack s10 = NDC.getCurrentStack();
        if (s10 != null && !s10.isEmpty()) {
            return ((DiagnosticContext)s10.peek()).fullMessage;
        }
        return null;
    }

    public static int getDepth() {
        Stack stack = NDC.getCurrentStack();
        if (stack == null) {
            return 0;
        }
        return stack.size();
    }

    private static void lazyRemove() {
        Thread t10;
        Vector<Thread> v10;
        if (ht == null) {
            return;
        }
        Hashtable hashtable = ht;
        synchronized (hashtable) {
            if (++pushCounter <= 5) {
                return;
            }
            pushCounter = 0;
            int misses = 0;
            v10 = new Vector<Thread>();
            Enumeration enumeration = ht.keys();
            while (enumeration.hasMoreElements() && misses <= 4) {
                t10 = (Thread)enumeration.nextElement();
                if (t10.isAlive()) {
                    ++misses;
                    continue;
                }
                misses = 0;
                v10.addElement(t10);
            }
        }
        int size = v10.size();
        int i10 = 0;
        while (i10 < size) {
            t10 = (Thread)v10.elementAt(i10);
            LogLog.debug("Lazy NDC removal for thread [" + t10.getName() + "] (" + ht.size() + ").");
            ht.remove(t10);
            ++i10;
        }
    }

    public static String pop() {
        Stack stack = NDC.getCurrentStack();
        if (stack != null && !stack.isEmpty()) {
            return ((DiagnosticContext)stack.pop()).message;
        }
        return "";
    }

    public static String peek() {
        Stack stack = NDC.getCurrentStack();
        if (stack != null && !stack.isEmpty()) {
            return ((DiagnosticContext)stack.peek()).message;
        }
        return "";
    }

    public static void push(String message) {
        Stack<DiagnosticContext> stack = NDC.getCurrentStack();
        if (stack == null) {
            DiagnosticContext dc2 = new DiagnosticContext(message, null);
            stack = new Stack<DiagnosticContext>();
            Thread key = Thread.currentThread();
            ht.put(key, stack);
            stack.push(dc2);
        } else if (stack.isEmpty()) {
            DiagnosticContext dc3 = new DiagnosticContext(message, null);
            stack.push(dc3);
        } else {
            DiagnosticContext parent = (DiagnosticContext)stack.peek();
            stack.push(new DiagnosticContext(message, parent));
        }
    }

    public static void remove() {
        ht.remove(Thread.currentThread());
        NDC.lazyRemove();
    }

    public static void setMaxDepth(int maxDepth) {
        Stack stack = NDC.getCurrentStack();
        if (stack != null && maxDepth < stack.size()) {
            stack.setSize(maxDepth);
        }
    }

    private static class DiagnosticContext {
        String fullMessage;
        String message;

        DiagnosticContext(String message, DiagnosticContext parent) {
            this.message = message;
            this.fullMessage = parent != null ? parent.fullMessage + ' ' + message : message;
        }
    }
}

