/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.QuietWriter;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.LoggingEvent;

public class WriterAppender
extends AppenderSkeleton {
    protected boolean immediateFlush = true;
    protected String encoding;
    protected QuietWriter qw;

    public WriterAppender() {
    }

    public WriterAppender(Layout layout, OutputStream os2) {
        this(layout, new OutputStreamWriter(os2));
    }

    public WriterAppender(Layout layout, Writer writer) {
        this.layout = layout;
        this.setWriter(writer);
    }

    public void setImmediateFlush(boolean value) {
        this.immediateFlush = value;
    }

    public boolean getImmediateFlush() {
        return this.immediateFlush;
    }

    public void activateOptions() {
    }

    public void append(LoggingEvent event) {
        if (!this.checkEntryConditions()) {
            return;
        }
        this.subAppend(event);
    }

    protected boolean checkEntryConditions() {
        if (this.closed) {
            LogLog.warn("Not allowed to write to a closed appender.");
            return false;
        }
        if (this.qw == null) {
            this.errorHandler.error("No output stream or file set for the appender named [" + this.name + "].");
            return false;
        }
        if (this.layout == null) {
            this.errorHandler.error("No layout set for the appender named [" + this.name + "].");
            return false;
        }
        return true;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.writeFooter();
        this.reset();
    }

    protected void closeWriter() {
        if (this.qw != null) {
            try {
                this.qw.close();
            }
            catch (IOException e10) {
                LogLog.error("Could not close " + this.qw, e10);
            }
        }
    }

    protected OutputStreamWriter createWriter(OutputStream os2) {
        OutputStreamWriter retval = null;
        String enc = this.getEncoding();
        if (enc != null) {
            try {
                retval = new OutputStreamWriter(os2, enc);
            }
            catch (IOException e10) {
                LogLog.warn("Error initializing output writer.");
                LogLog.warn("Unsupported encoding?");
            }
        }
        if (retval == null) {
            retval = new OutputStreamWriter(os2);
        }
        return retval;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String value) {
        this.encoding = value;
    }

    public synchronized void setErrorHandler(ErrorHandler eh2) {
        if (eh2 == null) {
            LogLog.warn("You have tried to set a null error-handler.");
        } else {
            this.errorHandler = eh2;
            if (this.qw != null) {
                this.qw.setErrorHandler(eh2);
            }
        }
    }

    public synchronized void setWriter(Writer writer) {
        this.reset();
        this.qw = new QuietWriter(writer, this.errorHandler);
        this.writeHeader();
    }

    protected void subAppend(LoggingEvent event) {
        String[] s10;
        this.qw.write(this.layout.format(event));
        if (this.layout.ignoresThrowable() && (s10 = event.getThrowableStrRep()) != null) {
            int len = s10.length;
            int i10 = 0;
            while (i10 < len) {
                this.qw.write(s10[i10]);
                this.qw.write(Layout.LINE_SEP);
                ++i10;
            }
        }
        if (this.immediateFlush) {
            this.qw.flush();
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    protected void reset() {
        this.closeWriter();
        this.qw = null;
    }

    protected void writeFooter() {
        String f10;
        if (this.layout != null && (f10 = this.layout.getFooter()) != null && this.qw != null) {
            this.qw.write(f10);
            this.qw.flush();
        }
    }

    protected void writeHeader() {
        String h10;
        if (this.layout != null && (h10 = this.layout.getHeader()) != null && this.qw != null) {
            this.qw.write(h10);
        }
    }
}

