/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.EventDetails;
import org.apache.log4j.chainsaw.MyTableModel;

class DetailPanel
extends JPanel
implements ListSelectionListener {
    private static final Logger LOG = Logger.getLogger(class$org$apache$log4j$chainsaw$DetailPanel == null ? (class$org$apache$log4j$chainsaw$DetailPanel = DetailPanel.class$("org.apache.log4j.chainsaw.DetailPanel")) : class$org$apache$log4j$chainsaw$DetailPanel);
    private static final MessageFormat FORMATTER = new MessageFormat("<b>Time:</b> <code>{0,time,medium}</code>&nbsp;&nbsp;<b>Priority:</b> <code>{1}</code>&nbsp;&nbsp;<b>Thread:</b> <code>{2}</code>&nbsp;&nbsp;<b>NDC:</b> <code>{3}</code><br><b>Logger:</b> <code>{4}</code><br><b>Location:</b> <code>{5}</code><br><b>Message:</b><pre>{6}</pre><b>Throwable:</b><pre>{7}</pre>");
    private final MyTableModel mModel;
    private final JEditorPane mDetails;
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$DetailPanel;

    DetailPanel(JTable aTable, MyTableModel aModel) {
        this.mModel = aModel;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Details: "));
        this.mDetails = new JEditorPane();
        this.mDetails.setEditable(false);
        this.mDetails.setContentType("text/html");
        this.add((Component)new JScrollPane(this.mDetails), "Center");
        ListSelectionModel rowSM = aTable.getSelectionModel();
        rowSM.addListSelectionListener(this);
    }

    public void valueChanged(ListSelectionEvent aEvent) {
        if (aEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)aEvent.getSource();
        if (lsm.isSelectionEmpty()) {
            this.mDetails.setText("Nothing selected");
        } else {
            int selectedRow = lsm.getMinSelectionIndex();
            EventDetails e10 = this.mModel.getEventDetails(selectedRow);
            Object[] args = new Object[]{new Date(e10.getTimeStamp()), e10.getPriority(), this.escape(e10.getThreadName()), this.escape(e10.getNDC()), this.escape(e10.getCategoryName()), this.escape(e10.getLocationDetails()), this.escape(e10.getMessage()), this.escape(DetailPanel.getThrowableStrRep(e10))};
            this.mDetails.setText(FORMATTER.format(args));
            this.mDetails.setCaretPosition(0);
        }
    }

    private static String getThrowableStrRep(EventDetails aEvent) {
        String[] strs = aEvent.getThrowableStrRep();
        if (strs == null) {
            return null;
        }
        StringBuffer sb2 = new StringBuffer();
        int i10 = 0;
        while (i10 < strs.length) {
            sb2.append(strs[i10]).append("\n");
            ++i10;
        }
        return sb2.toString();
    }

    private String escape(String aStr) {
        if (aStr == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int i10 = 0;
        while (i10 < aStr.length()) {
            char c10 = aStr.charAt(i10);
            switch (c10) {
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                default: {
                    buf.append(c10);
                }
            }
            ++i10;
        }
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x02) {
        try {
            return Class.forName(x02);
        }
        catch (ClassNotFoundException x12) {
            throw new NoClassDefFoundError(x12.getMessage());
        }
    }
}

