/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.EventDetails;
import org.apache.log4j.chainsaw.MyTableModel;
import org.apache.log4j.spi.LoggingEvent;

class LoggingReceiver
extends Thread {
    private static final Logger LOG = Logger.getLogger(class$org$apache$log4j$chainsaw$LoggingReceiver == null ? (class$org$apache$log4j$chainsaw$LoggingReceiver = LoggingReceiver.class$("org.apache.log4j.chainsaw.LoggingReceiver")) : class$org$apache$log4j$chainsaw$LoggingReceiver);
    private MyTableModel mModel;
    private ServerSocket mSvrSock;
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$LoggingReceiver;

    LoggingReceiver(MyTableModel aModel, int aPort) throws IOException {
        this.setDaemon(true);
        this.mModel = aModel;
        this.mSvrSock = new ServerSocket(aPort);
    }

    public void run() {
        LOG.info("Thread started");
        try {
            while (true) {
                LOG.debug("Waiting for a connection");
                Socket client = this.mSvrSock.accept();
                LOG.debug("Got a connection from " + client.getInetAddress().getHostName());
                Thread t10 = new Thread(new Slurper(client));
                t10.setDaemon(true);
                t10.start();
            }
        }
        catch (IOException e10) {
            LOG.error("Error in accepting connections, stopping.", e10);
            return;
        }
    }

    static /* synthetic */ Class class$(String x02) {
        try {
            return Class.forName(x02);
        }
        catch (ClassNotFoundException x12) {
            throw new NoClassDefFoundError(x12.getMessage());
        }
    }

    private class Slurper
    implements Runnable {
        private final Socket mClient;

        Slurper(Socket aClient) {
            this.mClient = aClient;
        }

        public void run() {
            LOG.debug("Starting to get data");
            try {
                ObjectInputStream ois = new ObjectInputStream(this.mClient.getInputStream());
                while (true) {
                    LoggingEvent event = (LoggingEvent)ois.readObject();
                    LoggingReceiver.this.mModel.addEvent(new EventDetails(event));
                }
            }
            catch (EOFException e10) {
                LOG.info("Reached EOF, closing connection");
            }
            catch (SocketException e11) {
                LOG.info("Caught SocketException, closing connection");
            }
            catch (IOException e12) {
                LOG.warn("Got IOException, closing connection", e12);
            }
            catch (ClassNotFoundException e13) {
                LOG.warn("Got ClassNotFoundException, closing connection", e13);
            }
            try {
                this.mClient.close();
            }
            catch (IOException e14) {
                LOG.warn("Error closing connection", e14);
            }
        }
    }
}

