/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.config;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.config.PropertySetterException;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.OptionHandler;

public class PropertySetter {
    protected Object obj;
    protected PropertyDescriptor[] props;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$log4j$Priority;

    public PropertySetter(Object obj) {
        this.obj = obj;
    }

    protected void introspect() {
        try {
            BeanInfo bi2 = Introspector.getBeanInfo(this.obj.getClass());
            this.props = bi2.getPropertyDescriptors();
        }
        catch (IntrospectionException ex2) {
            LogLog.error("Failed to introspect " + this.obj + ": " + ex2.getMessage());
            this.props = new PropertyDescriptor[0];
        }
    }

    public static void setProperties(Object obj, Properties properties, String prefix) {
        new PropertySetter(obj).setProperties(properties, prefix);
    }

    public void setProperties(Properties properties, String prefix) {
        int len = prefix.length();
        Enumeration<?> e10 = properties.propertyNames();
        while (e10.hasMoreElements()) {
            String key = (String)e10.nextElement();
            if (!key.startsWith(prefix) || key.indexOf(46, len + 1) > 0) continue;
            String value = OptionConverter.findAndSubst(key, properties);
            if ("layout".equals(key = key.substring(len)) && this.obj instanceof Appender) continue;
            this.setProperty(key, value);
        }
        this.activate();
    }

    public void setProperty(String name, String value) {
        if (value == null) {
            return;
        }
        PropertyDescriptor prop = this.getPropertyDescriptor(name = Introspector.decapitalize(name));
        if (prop == null) {
            LogLog.warn("No such property [" + name + "] in " + this.obj.getClass().getName() + ".");
        } else {
            try {
                this.setProperty(prop, name, value);
            }
            catch (PropertySetterException ex2) {
                LogLog.warn("Failed to set property [" + name + "] to value \"" + value + "\". ", ex2.rootCause);
            }
        }
    }

    public void setProperty(PropertyDescriptor prop, String name, String value) throws PropertySetterException {
        Object arg;
        Method setter = prop.getWriteMethod();
        if (setter == null) {
            throw new PropertySetterException("No setter for property [" + name + "].");
        }
        Class<?>[] paramTypes = setter.getParameterTypes();
        if (paramTypes.length != 1) {
            throw new PropertySetterException("#params for setter != 1");
        }
        try {
            arg = this.convertArg(value, paramTypes[0]);
        }
        catch (Throwable t10) {
            throw new PropertySetterException("Conversion to type [" + paramTypes[0] + "] failed. Reason: " + t10);
        }
        if (arg == null) {
            throw new PropertySetterException("Conversion to type [" + paramTypes[0] + "] failed.");
        }
        LogLog.debug("Setting property [" + name + "] to [" + arg + "].");
        try {
            setter.invoke(this.obj, arg);
        }
        catch (Exception ex2) {
            throw new PropertySetterException(ex2);
        }
    }

    protected Object convertArg(String val, Class type) {
        if (val == null) {
            return null;
        }
        String v10 = val.trim();
        if ((class$java$lang$String == null ? (class$java$lang$String = PropertySetter.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(type)) {
            return val;
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            return new Integer(v10);
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            return new Long(v10);
        }
        if (Boolean.TYPE.isAssignableFrom(type)) {
            if ("true".equalsIgnoreCase(v10)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(v10)) {
                return Boolean.FALSE;
            }
        } else if ((class$org$apache$log4j$Priority == null ? (class$org$apache$log4j$Priority = PropertySetter.class$("org.apache.log4j.Priority")) : class$org$apache$log4j$Priority).isAssignableFrom(type)) {
            return OptionConverter.toLevel(v10, Level.DEBUG);
        }
        return null;
    }

    protected PropertyDescriptor getPropertyDescriptor(String name) {
        if (this.props == null) {
            this.introspect();
        }
        int i10 = 0;
        while (i10 < this.props.length) {
            if (name.equals(this.props[i10].getName())) {
                return this.props[i10];
            }
            ++i10;
        }
        return null;
    }

    public void activate() {
        if (this.obj instanceof OptionHandler) {
            ((OptionHandler)this.obj).activateOptions();
        }
    }

    static /* synthetic */ Class class$(String x02) {
        try {
            return Class.forName(x02);
        }
        catch (ClassNotFoundException x12) {
            throw new NoClassDefFoundError(x12.getMessage());
        }
    }
}

