/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LoggingEvent;

public class AppenderAttachableImpl
implements AppenderAttachable {
    protected Vector appenderList;

    public void addAppender(Appender newAppender) {
        if (newAppender == null) {
            return;
        }
        if (this.appenderList == null) {
            this.appenderList = new Vector(1);
        }
        if (!this.appenderList.contains(newAppender)) {
            this.appenderList.addElement(newAppender);
        }
    }

    public int appendLoopOnAppenders(LoggingEvent event) {
        int size = 0;
        if (this.appenderList != null) {
            size = this.appenderList.size();
            int i10 = 0;
            while (i10 < size) {
                Appender appender = (Appender)this.appenderList.elementAt(i10);
                appender.doAppend(event);
                ++i10;
            }
        }
        return size;
    }

    public Enumeration getAllAppenders() {
        if (this.appenderList == null) {
            return null;
        }
        return this.appenderList.elements();
    }

    public Appender getAppender(String name) {
        if (this.appenderList == null || name == null) {
            return null;
        }
        int size = this.appenderList.size();
        int i10 = 0;
        while (i10 < size) {
            Appender appender = (Appender)this.appenderList.elementAt(i10);
            if (name.equals(appender.getName())) {
                return appender;
            }
            ++i10;
        }
        return null;
    }

    public boolean isAttached(Appender appender) {
        if (this.appenderList == null || appender == null) {
            return false;
        }
        int size = this.appenderList.size();
        int i10 = 0;
        while (i10 < size) {
            Appender a10 = (Appender)this.appenderList.elementAt(i10);
            if (a10 == appender) {
                return true;
            }
            ++i10;
        }
        return false;
    }

    public void removeAllAppenders() {
        if (this.appenderList != null) {
            int len = this.appenderList.size();
            int i10 = 0;
            while (i10 < len) {
                Appender a10 = (Appender)this.appenderList.elementAt(i10);
                a10.close();
                ++i10;
            }
            this.appenderList.removeAllElements();
            this.appenderList = null;
        }
    }

    public void removeAppender(Appender appender) {
        if (appender == null || this.appenderList == null) {
            return;
        }
        this.appenderList.removeElement(appender);
    }

    public void removeAppender(String name) {
        if (name == null || this.appenderList == null) {
            return;
        }
        int size = this.appenderList.size();
        int i10 = 0;
        while (i10 < size) {
            if (name.equals(((Appender)this.appenderList.elementAt(i10)).getName())) {
                this.appenderList.removeElementAt(i10);
                break;
            }
            ++i10;
        }
    }
}

