/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.Configurator;
import org.apache.log4j.spi.LoggerRepository;

public class OptionConverter {
    static String DELIM_START = "${";
    static char DELIM_STOP = (char)125;
    static int DELIM_START_LEN = 2;
    static int DELIM_STOP_LEN = 1;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$log4j$Level;
    static /* synthetic */ Class class$org$apache$log4j$spi$Configurator;

    private OptionConverter() {
    }

    public static String[] concatanateArrays(String[] l10, String[] r10) {
        int len = l10.length + r10.length;
        String[] a10 = new String[len];
        System.arraycopy(l10, 0, a10, 0, l10.length);
        System.arraycopy(r10, 0, a10, l10.length, r10.length);
        return a10;
    }

    public static String convertSpecialChars(String s10) {
        int len = s10.length();
        StringBuffer sbuf = new StringBuffer(len);
        int i10 = 0;
        while (i10 < len) {
            int c10;
            if ((c10 = s10.charAt(i10++)) == 92) {
                if ((c10 = s10.charAt(i10++)) == 110) {
                    c10 = 10;
                } else if (c10 == 114) {
                    c10 = 13;
                } else if (c10 == 116) {
                    c10 = 9;
                } else if (c10 == 102) {
                    c10 = 12;
                } else if (c10 == 8) {
                    c10 = 8;
                } else if (c10 == 34) {
                    c10 = 34;
                } else if (c10 == 39) {
                    c10 = 39;
                } else if (c10 == 92) {
                    c10 = 92;
                }
            }
            sbuf.append((char)c10);
        }
        return sbuf.toString();
    }

    public static String getSystemProperty(String key, String def) {
        try {
            return System.getProperty(key, def);
        }
        catch (Throwable e10) {
            LogLog.debug("Was not allowed to read system property \"" + key + "\".");
            return def;
        }
    }

    public static Object instantiateByKey(Properties props, String key, Class superClass, Object defaultValue) {
        String className = OptionConverter.findAndSubst(key, props);
        if (className == null) {
            LogLog.error("Could not find value for key " + key);
            return defaultValue;
        }
        return OptionConverter.instantiateByClassName(className.trim(), superClass, defaultValue);
    }

    public static boolean toBoolean(String value, boolean dEfault) {
        if (value == null) {
            return dEfault;
        }
        String trimmedVal = value.trim();
        if ("true".equalsIgnoreCase(trimmedVal)) {
            return true;
        }
        if ("false".equalsIgnoreCase(trimmedVal)) {
            return false;
        }
        return dEfault;
    }

    public static int toInt(String value, int dEfault) {
        if (value != null) {
            String s10 = value.trim();
            try {
                return Integer.valueOf(s10);
            }
            catch (NumberFormatException e10) {
                LogLog.error("[" + s10 + "] is not in proper int form.");
                e10.printStackTrace();
            }
        }
        return dEfault;
    }

    public static Level toLevel(String value, Level defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        int hashIndex = (value = value.trim()).indexOf(35);
        if (hashIndex == -1) {
            if ("NULL".equalsIgnoreCase(value)) {
                return null;
            }
            return Level.toLevel(value, defaultValue);
        }
        Level result = defaultValue;
        String clazz = value.substring(hashIndex + 1);
        String levelName = value.substring(0, hashIndex);
        if ("NULL".equalsIgnoreCase(levelName)) {
            return null;
        }
        LogLog.debug("toLevel:class=[" + clazz + "]" + ":pri=[" + levelName + "]");
        try {
            Class customLevel = Loader.loadClass(clazz);
            Class[] paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = OptionConverter.class$("java.lang.String")) : class$java$lang$String, class$org$apache$log4j$Level == null ? (class$org$apache$log4j$Level = OptionConverter.class$("org.apache.log4j.Level")) : class$org$apache$log4j$Level};
            Method toLevelMethod = customLevel.getMethod("toLevel", paramTypes);
            Object[] params = new Object[]{levelName, defaultValue};
            Object o10 = toLevelMethod.invoke(null, params);
            result = (Level)o10;
        }
        catch (ClassNotFoundException e10) {
            LogLog.warn("custom level class [" + clazz + "] not found.");
        }
        catch (NoSuchMethodException e11) {
            LogLog.warn("custom level class [" + clazz + "]" + " does not have a constructor which takes one string parameter", e11);
        }
        catch (InvocationTargetException e12) {
            LogLog.warn("custom level class [" + clazz + "]" + " could not be instantiated", e12);
        }
        catch (ClassCastException e13) {
            LogLog.warn("class [" + clazz + "] is not a subclass of org.apache.log4j.Level", e13);
        }
        catch (IllegalAccessException e14) {
            LogLog.warn("class [" + clazz + "] cannot be instantiated due to access restrictions", e14);
        }
        catch (Exception e15) {
            LogLog.warn("class [" + clazz + "], level [" + levelName + "] conversion failed.", e15);
        }
        return result;
    }

    public static long toFileSize(String value, long dEfault) {
        if (value == null) {
            return dEfault;
        }
        String s10 = value.trim().toUpperCase();
        long multiplier = 1L;
        int index = s10.indexOf("KB");
        if (index != -1) {
            multiplier = 1024L;
            s10 = s10.substring(0, index);
        } else {
            index = s10.indexOf("MB");
            if (index != -1) {
                multiplier = 0x100000L;
                s10 = s10.substring(0, index);
            } else {
                index = s10.indexOf("GB");
                if (index != -1) {
                    multiplier = 0x40000000L;
                    s10 = s10.substring(0, index);
                }
            }
        }
        if (s10 != null) {
            try {
                return Long.valueOf(s10) * multiplier;
            }
            catch (NumberFormatException e10) {
                LogLog.error("[" + s10 + "] is not in proper int form.");
                LogLog.error("[" + value + "] not in expected format.", e10);
            }
        }
        return dEfault;
    }

    public static String findAndSubst(String key, Properties props) {
        String value = props.getProperty(key);
        if (value == null) {
            return null;
        }
        try {
            return OptionConverter.substVars(value, props);
        }
        catch (IllegalArgumentException e10) {
            LogLog.error("Bad option value [" + value + "].", e10);
            return value;
        }
    }

    public static Object instantiateByClassName(String className, Class superClass, Object defaultValue) {
        if (className != null) {
            try {
                Class classObj = Loader.loadClass(className);
                if (!superClass.isAssignableFrom(classObj)) {
                    LogLog.error("A \"" + className + "\" object is not assignable to a \"" + superClass.getName() + "\" variable.");
                    LogLog.error("The class \"" + superClass.getName() + "\" was loaded by ");
                    LogLog.error("[" + superClass.getClassLoader() + "] whereas object of type ");
                    LogLog.error("\"" + classObj.getName() + "\" was loaded by [" + classObj.getClassLoader() + "].");
                    return defaultValue;
                }
                return classObj.newInstance();
            }
            catch (Exception e10) {
                LogLog.error("Could not instantiate class [" + className + "].", e10);
            }
        }
        return defaultValue;
    }

    public static String substVars(String val, Properties props) throws IllegalArgumentException {
        StringBuffer sbuf = new StringBuffer();
        int i10 = 0;
        while (true) {
            int j10;
            if ((j10 = val.indexOf(DELIM_START, i10)) == -1) {
                if (i10 == 0) {
                    return val;
                }
                sbuf.append(val.substring(i10, val.length()));
                return sbuf.toString();
            }
            sbuf.append(val.substring(i10, j10));
            int k10 = val.indexOf(DELIM_STOP, j10);
            if (k10 == -1) {
                throw new IllegalArgumentException('\"' + val + "\" has no closing brace. Opening brace at position " + j10 + '.');
            }
            String key = val.substring(j10 += DELIM_START_LEN, k10);
            String replacement = OptionConverter.getSystemProperty(key, null);
            if (replacement == null && props != null) {
                replacement = props.getProperty(key);
            }
            if (replacement != null) {
                String recursiveReplacement = OptionConverter.substVars(replacement, props);
                sbuf.append(recursiveReplacement);
            }
            i10 = k10 + DELIM_STOP_LEN;
        }
    }

    public static void selectAndConfigure(URL url, String clazz, LoggerRepository hierarchy) {
        Configurator configurator = null;
        String filename = url.getFile();
        if (clazz == null && filename != null && filename.endsWith(".xml")) {
            clazz = "org.apache.log4j.xml.DOMConfigurator";
        }
        if (clazz != null) {
            LogLog.debug("Preferred configurator class: " + clazz);
            configurator = (Configurator)OptionConverter.instantiateByClassName(clazz, class$org$apache$log4j$spi$Configurator == null ? (class$org$apache$log4j$spi$Configurator = OptionConverter.class$("org.apache.log4j.spi.Configurator")) : class$org$apache$log4j$spi$Configurator, null);
            if (configurator == null) {
                LogLog.error("Could not instantiate configurator [" + clazz + "].");
                return;
            }
        } else {
            configurator = new PropertyConfigurator();
        }
        configurator.doConfigure(url, hierarchy);
    }

    static /* synthetic */ Class class$(String x02) {
        try {
            return Class.forName(x02);
        }
        catch (ClassNotFoundException x12) {
            throw new NoClassDefFoundError(x12.getMessage());
        }
    }
}

